% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rid.R
\name{rid}
\alias{rid}
\title{robust interaction detector(RID) model}
\usage{
rid(
  formula,
  data,
  overlaymethod = "and",
  discvar,
  discnum = NULL,
  minsize = NULL,
  cores = 1
)
}
\arguments{
\item{formula}{A formula of RID model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{overlaymethod}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}

\item{discvar}{Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns.}

\item{discnum}{A numeric vector for the number of discretized classes of columns that need
to be discretized. Default all \code{discvar} use \code{10}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer(default is 1). If cores > 1, use parallel computation.}
}
\value{
A list of the RID model result.
\describe{
\item{\code{interaction}}{the result of RID model}
}
}
\description{
Function for robust interaction detector(RID) model.
}
\note{
For bivariate spatial interactions, use the \code{RGD} function and specify the \code{type} parameter as \code{interaction}.

The RID model requires at least \eqn{2^n-1} calculations when has \eqn{n} explanatory variables.
When there are more than 10 explanatory variables, carefully consider the computational burden of this model.
When there are a large number of explanatory variables, the data dimensionality reduction method can be used
to ensure the trade-off between analysis results and calculation speed.

Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rid()}.
See \code{vignette('RGDRID',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('sim')
g = rid(y ~ ., data = sim \%>\% dplyr::select(-dplyr::any_of(c('lo','la'))),
        discvar = c("xa","xb","xc"), discnum = 4, cores = 6)
g
}
}
\references{
Zhang, Z., Song, Y., Karunaratne, L., & Wu, P. (2024). Robust interaction detector:
A case of road life expectancy analysis. Spatial Statistics, 59(100814), 100814.
https://doi.org/10.1016/j.spasta.2024.100814
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
