% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid_idsa.R
\name{pid_idsa}
\alias{pid_idsa}
\title{IDSA Q-saistics \code{PID}}
\usage{
pid_idsa(formula, rawdata, discdata, wt, overlaymethod = "and")
}
\arguments{
\item{formula}{A formula for IDSA Q-saistics}

\item{rawdata}{Raw observation data}

\item{discdata}{Observed data with discrete explanatory variables}

\item{wt}{Spatial weight matrix}

\item{overlaymethod}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}
}
\value{
The value of IDSA Q-saistics \code{PID}.
}
\description{
IDSA Q-saistics \code{PID}
}
\details{
\eqn{Q_{IDSA} = \frac{\theta_r}{\phi}}
}
\examples{
data('sim')
wt = inverse_distance_weight(sim$lo,sim$la)
sim1 = dplyr::mutate(sim,dplyr::across(xa:xc,\(.x) st_unidisc(.x,5)))
pid_idsa(y ~ xa + xb + xc, rawdata = sim,
         discdata = sim1, wt = wt)

}
