% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evgram-autoplot.R
\name{autoplot.evgram}
\alias{autoplot.evgram}
\title{Plot \code{evgram} object}
\usage{
\method{autoplot}{evgram}(object, ..., split = FALSE)
}
\arguments{
\item{object}{An \code{evgram} object produced by the
\code{\link[gear]{evgram}} function.}

\item{...}{Not used}

\item{split}{A logical value indicating whether, for a
directional semivariogram, the directional
semivariograms should be displayed in a single or split
panels.  Default is \code{FALSE}, for a single panel.}
}
\description{
Plots object of class '\code{evgram}' produced by the
\code{\link[gear]{evgram}} function. The plotting
function internally calls the
\code{\link[lattice]{xyplot}} function.
}
\examples{
data(co)
v = evgram(Al ~ 1, co, ~ easting + northing)
autoplot(v)
v2 = evgram(Al ~ 1, co, ~ easting + northing, angle = 22.5, ndir = 4)
autoplot(v2)
autoplot(v2, split = TRUE)
}
\author{
Joshua French
}
