% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_fn.R
\name{distance}
\alias{distance}
\title{Create distance layer.}
\usage{
distance(longlat, layers, type = "minimum")
}
\arguments{
\item{longlat}{Matrix of longitude and latitude or eastness and northness (two columns in this order) of species occurrence records.}

\item{layers}{Raster* object as defined by package raster to serve as model to create distance layer.}

\item{type}{text string indicating whether the output should be the "minimum", "average" or "mcp" distance to all records. "mcp" means the distance to the minimum convex polygon encompassing all records.}
}
\value{
A RasterLayer object.
}
\description{
Creates a layer depicting distances to records using the minimum, average, distance to the minimum convex polygon or distance taking into account a cost surface.
}
\details{
Using distance to records in models may help limiting the extrapolation of the predicted area much beyond known areas.
}
\examples{
userpar <- par(no.readonly = TRUE) 
data(gecko.layers)
alt = gecko.layers[[3]]
data(gecko.records)
par(mfrow=c(3,2))
raster::plot(alt)
points(gecko.records)
raster::plot(distance(gecko.records, alt))
raster::plot(distance(gecko.records, alt, type = "average"))
raster::plot(distance(gecko.records, alt, type = "mcp"))
par(userpar)
}
