% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_funs.R
\name{create_basis}
\alias{create_basis}
\title{Creates an m_estimation_basis object}
\usage{
create_basis(estFUN, data, units, outer_args, inner_args)
}
\arguments{
\item{estFUN}{a function that takes in group-level data and returns a function
that takes parameters as its first argument}

\item{data}{a data.frame}

\item{units}{an optional character string identifying the grouping variable in \code{data}}

\item{outer_args}{a list of arguments passed to the outer (data) function of \code{estFUN}. (optional)}

\item{inner_args}{a list of arguments passed to the inner (theta) function of \code{estFUN}. (optional)}
}
\value{
a \code{\linkS4class{m_estimation_basis}}
}
\description{
Creates an m_estimation_basis object
}
\details{
Either \code{data} or \code{split_data} must be provided
}
\examples{
myee <- function(data){
   function(theta){
    c(data$Y1 - theta[1],
     (data$Y1 - theta[1])^2 - theta[2])
   }
 }
mybasis <- create_basis(
   estFUN = myee,
   data   = geexex)
mybasis
}
