`ape2ouch` <-
function(phy, data)
{
	phy<-new2old.phylo(phy)
	n<-length(phy$edge.length)+1
	node<-1:n
	species<-character(n)
	species[1]<-NA
	species[which(phy$edge[,2]<0)+1]<-NA
	species[which(phy$edge[,2]>0)+1]<-phy$tip.label
	ancestor<-match(phy$edge[,1], phy$edge[,2])
	ancestor[is.na(ancestor)]<-0
	ancestor<-ancestor+1
	ancestor<-c(NA, ancestor)
	time<-numeric(n)
	time[1]<-0.0;
	for(i in 2:length(time))
		time[i]<-time[ancestor[i]]+phy$edge.length[i-1];
	d<-rep(NA, length(species))
    d[match(names(data),species)]<-data

	obj<-list(d=d, node=node, species=species, ancestor=ancestor, time=time)
	obj
}

`ouch2ape` <-
function(node, ancestor, time, species)
{
	node[is.na(species)]<--(1:sum(is.na(species)))
	node[!is.na(species)]<-1:sum(!is.na(species))
	new.ancestor<-node[as.numeric(ancestor)]
	edge<-cbind(new.ancestor[-1], node[-1])
	edge.length<-numeric(length(time)-1)
	for(i in 1:length(edge.length))
		edge.length[i]<-time[i+1]-time[as.numeric(ancestor[i+1])];
	tip.label<-species[!is.na(species)]
	mode(edge) <- "character"
    mode(tip.label) <- "character"
    obj <- list(edge = edge, edge.length = edge.length, tip.label=tip.label)
    class(obj) <- "phylo"
    old2new.phylo(obj)->obj
    obj
}

