% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_structured.R
\name{gemini_structured}
\alias{gemini_structured}
\title{Generate structured response from Gemini}
\usage{
gemini_structured(
  prompt,
  schema,
  model = "2.5-flash",
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234,
  timeout = 60
)
}
\arguments{
\item{prompt}{The prompt (question) to send to the model.}

\item{schema}{JSON schema (as a list) for the expected response.}

\item{model}{Model to use. Default is '2.5-flash'.}

\item{temperature}{Sampling temperature. Default is 1.}

\item{maxOutputTokens}{Maximum number of output tokens. Default is 8192.}

\item{topK}{Top-k value. Default is 40.}

\item{topP}{Top-p value. Default is 0.95.}

\item{seed}{Random seed. Default is 1234.}

\item{timeout}{Request timeout in seconds. Default is 60.}
}
\value{
A structured list (parsed JSON).
}
\description{
Returns a structured (JSON) response from the Gemini API.
}
\examples{
\dontrun{
schema <- list(
  type = "ARRAY",
  items = list(
    type = "OBJECT",
    properties = list(
      recipeName = list(type = "STRING"),
      ingredients = list(
        type = "ARRAY",
        items = list(type = "STRING")
      )
    ),
    propertyOrdering = c("recipeName", "ingredients")
  )
)
gemini_structured(
  "List a few popular cookie recipes, and include the amounts of ingredients.",
  schema
)
}
}
