/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.Task;
import org.drugis.common.threading.ThreadHandler;
import org.drugis.common.threading.activity.ActivityModel;
import org.drugis.common.threading.activity.ActivityTask;

public class TaskUtil {
    public static void run(ActivityModel model) throws InterruptedException {
        TaskUtil.run(new ActivityTask(model));
    }

    public static void run(Task task) throws InterruptedException {
        TaskUtil.start(task);
        TaskUtil.waitUntilReady(task);
    }

    private static void start(Task task) {
        ThreadHandler th = ThreadHandler.getInstance();
        th.scheduleTask(task);
    }

    public static void waitUntilReady(Task task) throws InterruptedException {
        while (TaskUtil.isRunning(task)) {
            Thread.sleep(100L);
        }
    }

    public static boolean isRunning(Task task) {
        if (task.isFailed()) {
            throw new RuntimeException("Task failed", task.getFailureCause());
        }
        return !task.isFinished() && !task.isAborted();
    }
}

