/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import edu.uci.ics.jung.graph.util.Pair;
import gov.lanl.yadas.ArgumentMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drugis.mtc.model.Treatment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigmaRowArgumentMaker
implements ArgumentMaker {
    private final int d_sigmaIdx;
    private final int d_row;
    private int d_nRows;
    private int d_from;
    private int d_to;

    public static List<ArgumentMaker> createMatrixArgumentMaker(List<List<Pair<Treatment>>> studyPmtz, int sigmaIdx) {
        ArrayList<ArgumentMaker> makers = new ArrayList<ArgumentMaker>();
        int row = 0;
        for (List<Pair<Treatment>> list : studyPmtz) {
            for (int i = 0; i < list.size(); ++i) {
                makers.add(new SigmaRowArgumentMaker(studyPmtz, row, sigmaIdx));
                ++row;
            }
        }
        return makers;
    }

    public SigmaRowArgumentMaker(List<List<Pair<Treatment>>> studyPmtz, int row, int sigmaIdx) {
        this.d_row = row;
        this.d_sigmaIdx = sigmaIdx;
        this.d_nRows = 0;
        for (List<Pair<Treatment>> list : studyPmtz) {
            if (row >= this.d_nRows && row < this.d_nRows + list.size()) {
                this.d_from = this.d_nRows;
                this.d_to = this.d_nRows + list.size();
            }
            this.d_nRows += list.size();
        }
    }

    @Override
    public double[] getArgument(double[][] data) {
        double sd = data[this.d_sigmaIdx][0];
        double var = sd * sd;
        double cov = var / 2.0;
        double[] arr = new double[this.d_nRows];
        Arrays.fill(arr, this.d_from, this.d_to, cov);
        arr[this.d_row] = var;
        return arr;
    }
}

