/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.validation;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Observable;
import com.jgoodies.binding.list.ObservableList;
import com.jgoodies.binding.value.AbstractValueModel;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.List;
import org.drugis.common.event.IndifferentListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUniqueModel<T extends Observable>
extends AbstractValueModel {
    private static final long serialVersionUID = 3238328450875732496L;
    private List<T> d_list;
    private T d_item;
    private PropertyDescriptor d_property;
    private boolean d_val;

    public PropertyUniqueModel(ObservableList<T> list, T item, String propertyName) {
        this((List<T>)list, item, propertyName);
        list.addListDataListener(new IndifferentListDataListener(){

            protected void update() {
                PropertyUniqueModel.this.update();
            }
        });
    }

    public PropertyUniqueModel(List<T> list, T item, final String propertyName) {
        this.d_list = list;
        this.d_item = item;
        try {
            this.d_property = BeanUtils.getPropertyDescriptor(item.getClass(), propertyName);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.d_item.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(propertyName)) {
                    PropertyUniqueModel.this.update();
                }
            }
        });
        this.d_val = this.calc();
    }

    @Override
    public Boolean getValue() {
        return this.d_val;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private void update() {
        boolean oldVal = this.d_val;
        this.d_val = this.calc();
        this.fireValueChange(oldVal, this.d_val);
    }

    private boolean calc() {
        for (Observable x : this.d_list) {
            if (x == this.d_item || !BindingUtils.equals(BeanUtils.getValue(x, this.d_property), BeanUtils.getValue(this.d_item, this.d_property))) continue;
            return false;
        }
        return true;
    }
}

