/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drugis.mtc.graph.GraphUtil;
import org.drugis.mtc.graph.MinimumDiameterSpanningTree;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.NetworkModel;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.ParameterComparator;
import org.drugis.mtc.parameterization.Parameterization;
import org.drugis.mtc.parameterization.TreatmentComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyParameterization
implements Parameterization {
    protected final Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> d_tree;
    private final Map<Study, Treatment> d_baselines;

    public static ConsistencyParameterization create(Network network) {
        Hypergraph<Treatment, Study> sGraph = NetworkModel.createStudyGraph(network);
        UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph = NetworkModel.createComparisonGraph(sGraph);
        Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree = ConsistencyParameterization.findSpanningTree(cGraph);
        Map<Study, Treatment> baselines = ConsistencyParameterization.findStudyBaselines(sGraph, tree);
        ConsistencyParameterization pmtz = new ConsistencyParameterization(network, tree, baselines);
        return pmtz;
    }

    public static Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> findSpanningTree(UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        MinimumDiameterSpanningTree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> mdst = new MinimumDiameterSpanningTree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>(cGraph, TreatmentComparator.INSTANCE);
        return mdst.getMinimumDiameterSpanningTree();
    }

    public static Map<Study, Treatment> findStudyBaselines(Hypergraph<Treatment, Study> studyGraph, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree) {
        HashMap<Study, Treatment> map = new HashMap<Study, Treatment>();
        for (Study s : studyGraph.getEdges()) {
            map.put(s, ConsistencyParameterization.findMaxDegreeVertex(tree, studyGraph.getIncidentVertices(s)));
        }
        return map;
    }

    protected static Treatment findMaxDegreeVertex(Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree, Collection<Treatment> incidentVertices) {
        Iterator<Treatment> iterator = incidentVertices.iterator();
        Treatment maxDegree = iterator.next();
        while (iterator.hasNext()) {
            Treatment t = iterator.next();
            int degreeDiff = tree.getNeighborCount(t) - tree.getNeighborCount(maxDegree);
            if (degreeDiff <= 0 && (degreeDiff != 0 || TreatmentComparator.INSTANCE.compare(t, maxDegree) >= 0)) continue;
            maxDegree = t;
        }
        return maxDegree;
    }

    public ConsistencyParameterization(Network network, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree, Map<Study, Treatment> baselines) {
        this.d_tree = tree;
        this.d_baselines = baselines;
    }

    @Override
    public List<NetworkParameter> getParameters() {
        List<NetworkParameter> list = ConsistencyParameterization.getBasicParameters(this.d_tree);
        Collections.sort(list, new ParameterComparator());
        return list;
    }

    public static List<NetworkParameter> getBasicParameters(Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree) {
        ArrayList<NetworkParameter> list = new ArrayList<NetworkParameter>();
        for (FoldingTransformerFixed.FoldedEdge e : tree.getEdges()) {
            Treatment v;
            Treatment u = (Treatment)e.getVertices().getFirst();
            if (tree.findEdge(u, v = (Treatment)e.getVertices().getSecond()) != null) {
                list.add(ConsistencyParameterization.createBasic(u, v));
                continue;
            }
            list.add(ConsistencyParameterization.createBasic(v, u));
        }
        return list;
    }

    @Override
    public Map<NetworkParameter, Integer> parameterize(Treatment ta, Treatment tb) {
        if (this.d_tree.findEdge(ta, tb) != null) {
            return Collections.singletonMap(ConsistencyParameterization.createBasic(ta, tb), 1);
        }
        if (this.d_tree.findEdge(tb, ta) != null) {
            return Collections.singletonMap(ConsistencyParameterization.createBasic(tb, ta), -1);
        }
        return this.parameterizeFunctional(ta, tb);
    }

    protected Map<NetworkParameter, Integer> parameterizeFunctional(Treatment ta, Treatment tb) {
        return this.pathToParameterization(GraphUtil.findPath(this.d_tree, ta, tb));
    }

    @Override
    public Treatment getStudyBaseline(Study s) {
        return this.d_baselines.get(s);
    }

    private Map<NetworkParameter, Integer> pathToParameterization(List<Treatment> path) {
        HashMap<NetworkParameter, Integer> map = new HashMap<NetworkParameter, Integer>();
        int i = 1;
        while (i < path.size()) {
            Treatment v;
            Treatment u = path.get(i - 1);
            if (this.d_tree.findEdge(u, v = path.get(i)) != null) {
                map.put(ConsistencyParameterization.createBasic(u, v), 1);
            } else {
                map.put(ConsistencyParameterization.createBasic(v, u), -1);
            }
            ++i;
        }
        return map;
    }

    private static BasicParameter createBasic(Treatment first, Treatment second) {
        return new BasicParameter(first, second);
    }

    @Override
    public List<List<Pair<Treatment>>> parameterizeStudy(Study s) {
        Treatment b = this.getStudyBaseline(s);
        ArrayList<Treatment> treatments = new ArrayList<Treatment>(s.getTreatments());
        treatments.remove(b);
        Collections.sort(treatments, TreatmentComparator.INSTANCE);
        ArrayList<Pair<Treatment>> list = new ArrayList<Pair<Treatment>>(s.getTreatments().size() - 1);
        for (Treatment t : treatments) {
            list.add(new Pair<Treatment>(b, t));
        }
        return Collections.singletonList(list);
    }

    @Override
    public Graph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> getBasicParameterTree() {
        return this.d_tree;
    }
}

