/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.UpdateTuner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drugis.common.threading.AbstractExtendableIterativeComputation;
import org.drugis.common.threading.AbstractIterativeComputation;
import org.drugis.common.threading.ExtendableIterativeTask;
import org.drugis.common.threading.IterativeTask;
import org.drugis.common.threading.NullTask;
import org.drugis.common.threading.SimpleSuspendableTask;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.WaitingTask;
import org.drugis.common.threading.activity.ActivityModel;
import org.drugis.common.threading.activity.ActivityTask;
import org.drugis.common.threading.activity.Condition;
import org.drugis.common.threading.activity.DecisionTransition;
import org.drugis.common.threading.activity.DirectTransition;
import org.drugis.common.threading.activity.ForkTransition;
import org.drugis.common.threading.activity.JoinTransition;
import org.drugis.common.threading.activity.Transition;
import org.drugis.mtc.MCMCModel;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCSettings;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.yadas.Derivation;
import org.drugis.mtc.yadas.ParameterWriter;
import org.drugis.mtc.yadas.YadasResults;
import org.drugis.mtc.yadas.YadasSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractYadasModel
implements MCMCModel {
    private List<List<ParameterWriter>> d_writeList = new ArrayList<List<ParameterWriter>>();
    private List<List<MCMCUpdate>> d_updateList = new ArrayList<List<MCMCUpdate>>();
    private int d_reportingInterval = 100;
    protected YadasResults d_results = new YadasResults();
    private YadasSettings d_settings;
    private ActivityTask d_activityTask;
    private SimpleSuspendableTask d_finalPhase;
    protected MCMCModel.ExtendSimulation d_extendSimulation = MCMCModel.ExtendSimulation.WAIT;
    private ExtendDecisionTask d_extendDecisionPhase;
    protected Task d_extendSimulationPhase;
    private SimpleRestartableSuspendableTask d_notifyResults;

    protected abstract void createChain(int var1);

    public AbstractYadasModel(MCMCSettings settings) {
        this.d_settings = new YadasSettings(settings);
        this.buildActivityModel();
    }

    private void buildActivityModel() {
        SimpleSuspendableTask buildModelPhase = new SimpleSuspendableTask(new Runnable(){

            public void run() {
                AbstractYadasModel.this.buildModel();
            }
        }, "Building model");
        ArrayList<TuningTask> tuningPhase = new ArrayList<TuningTask>(this.getNumberOfChains());
        final ArrayList<SimulationTask> simulationPhase = new ArrayList<SimulationTask>(this.getNumberOfChains());
        int i = 0;
        while (i < this.getNumberOfChains()) {
            tuningPhase.add(new TuningTask(i));
            simulationPhase.add(new SimulationTask(i));
            ++i;
        }
        this.d_extendDecisionPhase = new ExtendDecisionTask();
        this.d_extendSimulationPhase = new SimpleRestartableSuspendableTask(new Runnable(){

            public void run() {
                for (ExtendableIterativeTask t : simulationPhase) {
                    t.extend(AbstractYadasModel.this.getSimulationIterations());
                }
                AbstractYadasModel.this.d_results.setNumberOfIterations(AbstractYadasModel.this.getSimulationIterations() * 2 / AbstractYadasModel.this.getThinning());
                AbstractYadasModel.this.d_settings.setSimulationIterations(AbstractYadasModel.this.getSimulationIterations() * 2);
                AbstractYadasModel.this.d_notifyResults.reset();
                AbstractYadasModel.this.d_extendDecisionPhase.reset();
            }
        }, "Extending simulation");
        this.d_finalPhase = new NullTask();
        this.d_notifyResults = new SimpleRestartableSuspendableTask(new Runnable(){

            public void run() {
                AbstractYadasModel.this.d_results.simulationFinished();
            }
        }, "Calculating summaries");
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.add(new ForkTransition(buildModelPhase, tuningPhase));
        int i2 = 0;
        while (i2 < this.getNumberOfChains()) {
            transitions.add(new DirectTransition((Task)tuningPhase.get(i2), (Task)simulationPhase.get(i2)));
            ++i2;
        }
        transitions.add(new JoinTransition(simulationPhase, this.d_notifyResults));
        transitions.add(new DirectTransition(this.d_notifyResults, this.d_extendDecisionPhase));
        transitions.add(new DecisionTransition(this.d_extendDecisionPhase, this.d_extendSimulationPhase, this.d_finalPhase, new Condition(){

            public boolean evaluate() {
                return AbstractYadasModel.this.d_extendSimulation == MCMCModel.ExtendSimulation.EXTEND;
            }
        }));
        transitions.add(new ForkTransition(this.d_extendSimulationPhase, simulationPhase));
        ActivityModel activityModel = new ActivityModel(buildModelPhase, this.d_finalPhase, transitions);
        this.d_activityTask = new ActivityTask(activityModel, "MCMC model");
    }

    protected int getThinning() {
        return this.getSettings().getThinningInterval();
    }

    @Override
    public boolean isReady() {
        return this.d_activityTask.isFinished() || this.d_extendDecisionPhase.isStarted();
    }

    @Override
    public ActivityTask getActivityTask() {
        return this.d_activityTask;
    }

    @Override
    public void setTuningIterations(int it) {
        if (this.d_activityTask.isStarted()) {
            throw new IllegalAccessError("May not call setTuningIterations() once computations have started.");
        }
        this.validIt(it);
        this.d_settings.setTuningIterations(it);
        this.buildActivityModel();
    }

    @Override
    public void setSimulationIterations(int it) {
        if (this.d_activityTask.isStarted()) {
            throw new IllegalAccessError("May not call setTuningIterations() once computations have started.");
        }
        this.validIt(it);
        this.d_settings.setSimulationIterations(it);
        this.buildActivityModel();
    }

    @Override
    public MCMCResults getResults() {
        return this.d_results;
    }

    private void validIt(int it) {
        if (it <= 0 || it % 100 != 0) {
            throw new IllegalArgumentException("Specified # iterations should be a positive multiple of 100");
        }
    }

    private void buildModel() {
        this.prepareModel();
        this.d_results.setNumberOfChains(this.getNumberOfChains());
        this.d_results.setNumberOfIterations(this.getSimulationIterations() / this.getThinning());
        this.d_results.setDirectParameters(this.getParameters());
        this.d_results.setDerivedParameters(this.getDerivedParameters());
        int i = 0;
        while (i < this.getNumberOfChains()) {
            this.createChain(i);
            ++i;
        }
    }

    protected abstract List<Parameter> getParameters();

    protected Map<? extends Parameter, Derivation> getDerivedParameters() {
        return Collections.emptyMap();
    }

    protected abstract void prepareModel();

    protected void update(int chain) {
        for (MCMCUpdate u : this.d_updateList.get(chain)) {
            try {
                u.update();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to update " + u, e);
            }
        }
    }

    protected void output(int chain) {
        for (ParameterWriter p : this.d_writeList.get(chain)) {
            p.output();
        }
    }

    @Override
    public void setExtendSimulation(MCMCModel.ExtendSimulation s) {
        this.d_extendSimulation = s;
    }

    @Override
    public MCMCSettings getSettings() {
        return this.d_settings;
    }

    protected void addWriters(List<ParameterWriter> writers) {
        this.d_writeList.add(writers);
    }

    protected void addTuners(List<MCMCParameter> params) {
        ArrayList<UpdateTuner> tuners = new ArrayList<UpdateTuner>(params.size());
        for (MCMCParameter param : params) {
            tuners.add(new UpdateTuner(param, this.getTuningIterations() / 50, 50, 1, Math.exp(-1.0)));
        }
        this.d_updateList.add(tuners);
    }

    private int getTuningIterations() {
        return this.getSettings().getTuningIterations();
    }

    public int getSimulationIterations() {
        return this.getSettings().getSimulationIterations();
    }

    protected int getNumberOfChains() {
        return this.getSettings().getNumberOfChains();
    }

    final class ExtendDecisionTask
    extends WaitingTask {
        ExtendDecisionTask() {
        }

        public boolean isWaiting() {
            return AbstractYadasModel.this.d_extendSimulation == MCMCModel.ExtendSimulation.WAIT;
        }

        public void onEndWaiting() {
            this.d_started = false;
            this.d_finished = true;
            if (AbstractYadasModel.this.d_extendSimulation == MCMCModel.ExtendSimulation.EXTEND) {
                ((SimpleRestartableSuspendableTask)AbstractYadasModel.this.d_extendSimulationPhase).reset();
            }
            this.d_mgr.fireTaskFinished();
        }

        public void reset() {
            AbstractYadasModel.this.d_extendSimulation = MCMCModel.ExtendSimulation.WAIT;
            this.d_finished = false;
            this.d_mgr.fireTaskRestarted();
        }

        public String toString() {
            return "Assess convergence";
        }
    }

    class SimpleRestartableSuspendableTask
    extends SimpleSuspendableTask {
        public SimpleRestartableSuspendableTask(Runnable runnable, String string) {
            super(runnable, string);
        }

        public void reset() {
            this.d_started = false;
            this.d_finished = false;
            this.d_mgr.fireTaskRestarted();
        }
    }

    private class SimulationChain
    extends AbstractExtendableIterativeComputation {
        private final int d_chain;

        public SimulationChain(int chain) {
            super(AbstractYadasModel.this.getSimulationIterations());
            this.d_chain = chain;
        }

        public void doStep() {
            AbstractYadasModel.this.update(this.d_chain);
            if (this.d_iteration % AbstractYadasModel.this.getThinning() == 0) {
                AbstractYadasModel.this.output(this.d_chain);
            }
        }
    }

    class SimulationTask
    extends ExtendableIterativeTask {
        public SimulationTask(int chain) {
            super(new SimulationChain(chain), "Simulation: " + chain);
            this.setReportingInterval(AbstractYadasModel.this.d_reportingInterval);
        }
    }

    private class TuningChain
    extends AbstractIterativeComputation {
        private final int d_chain;

        public TuningChain(int chain) {
            super(AbstractYadasModel.this.getTuningIterations());
            this.d_chain = chain;
        }

        public void doStep() {
            AbstractYadasModel.this.update(this.d_chain);
        }
    }

    class TuningTask
    extends IterativeTask {
        public TuningTask(int chain) {
            super(new TuningChain(chain), "Tuning: " + chain);
            this.setReportingInterval(AbstractYadasModel.this.d_reportingInterval);
        }
    }
}

