% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Contingency-test}
\alias{Contingency-test}
\alias{struc}
\title{Exact test on a single contingency table}
\usage{
struc(
  inputFile,
  settingsFile = "",
  dememorization = 10000,
  batches = 100,
  iterations = 5000,
  verbose = interactive()
)
}
\arguments{
\item{inputFile}{character: The path of the input file. This file should be in an ad hoc format}

\item{settingsFile}{character: The path of the settings file}

\item{dememorization}{integer: length of dememorization step of Markov chain algorithm}

\item{batches}{integer: Number of batches}

\item{iterations}{integer: Iterations per batch}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Performs an exact conditional contingency-table test. There are many other ways of doing this in R but this function replicates the functionality of earlier genepop code analysing a contingency table provided in a file with ad hoc format. See \href{../doc/all-menu-options.html#analyzing-a-single-contingency-table}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
locinfile <- genepopExample('structest.txt')
struc(locinfile)
if ( ! interactive()) clean_workdir(otherfiles='structest.txt')
}
