% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcor_ijk.R
\name{parcor_ijk}
\alias{parcor_ijk}
\title{Generalized partial correlation coefficient between Xi and Xj removing the
effect of all other columns using the matrix R* of generalized correlation coefficients.}
\usage{
parcor_ijk(x, i, j)
}
\arguments{
\item{x}{{has a p by p matrix R* of generalized corr coefficients.}}

\item{i}{{A column number identifying the first variable.}}

\item{j}{{A column number identifying the second variable.}}
}
\value{
\item{ouij}{partial correlation Xi on Xj (=cause) after removing all other X's}
\item{ouji}{partial correlation Xj on Xi (=cause) after removing all other X's}
\item{myk}{list of column numbers whose effect has been removed}
}
\description{
This function uses a generalized correlation matrix R* as input to compute
generalized partial correlations between \eqn{X_i} and one of the remaining
variables after removing the effect of all other variables in the matrix.
}
\note{
This function calls \code{\link{minor}}, and \code{\link{cofactor}} and is called 
  by \code{parcor_ridge}.
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c("V1", "v2", "V3")
gm1=gmcmtx0(x)
parcor_ijk(gm1, 2,3)
}#' 
}

