% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fam.R
\name{write_fam}
\alias{write_fam}
\title{Write Plink *.fam files}
\usage{
write_fam(file, tib, verbose = TRUE)
}
\arguments{
\item{file}{Output file (whatever is accepted by \code{\link[readr:write_delim]{readr::write_tsv()}}).
If file is missing the expected *.fam extension, the function adds it.}

\item{tib}{The tibble or data.frame to write.
It must contain these columns: \code{fam}, \code{id}, \code{pat}, \code{mat}, \code{sex}, \code{pheno}.
Throws an error if any of these columns are missing.
Additional columns are ignored.
Columns are automatically reordered in output as expected in format.}

\item{verbose}{If \code{TRUE} (default), function reports the path of the file being written (after autocompleting the extension).}
}
\value{
The output \code{tib} invisibly (what \code{\link[readr:write_delim]{readr::write_tsv()}} returns).
}
\description{
This function writes a tibble with the right columns into a standard Plink *.fam file.
It uses \code{\link[readr:write_delim]{readr::write_tsv()}} to do it efficiently.
}
\examples{
# to write an existing table `fam` into file "data.fam", run like this:
# write_fam("data", fam)
# this also works
# write_fam("data.fam", fam)

# The following example is more detailed but also more awkward
# because (only for these examples) the package must create the file in a *temporary* location

# create a dummy tibble with the right columns
library(tibble)
tib <- tibble(
    fam = 1:3,
    id = 1:3,
    pat = 0,
    mat = 0,
    sex = 1,
    pheno = 1
)
# a dummy file
file_out <- tempfile('delete-me-example', fileext = '.fam') # will also work without extension
# write the table out in *.fam format (no header, columns in right order)
write_fam(file_out, tib)
# delete output when done
file.remove(file_out)

}
\seealso{
\code{\link[=write_plink]{write_plink()}} for writing a set of BED/BIM/FAM files.

Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
