% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bim.R
\name{read_bim}
\alias{read_bim}
\title{Read Plink *.bim files}
\usage{
read_bim(file, verbose = TRUE)
}
\arguments{
\item{file}{Input file (whatever is accepted by \code{\link[readr:read_table]{readr::read_table()}}).
If file as given does not exist and is missing the expected *.bim extension, the function adds the .bim extension and uses that path if that file exists.
Additionally, the .gz extension is added automatically if the file (after *.bim extension is added as needed) is still not found and did not already contain the .gz extension and adding it points to an existing file.}

\item{verbose}{If \code{TRUE} (default) function reports the path of the file being loaded (after autocompleting the extensions).}
}
\value{
A tibble with columns: \code{chr}, \code{id}, \code{posg}, \code{pos}, \code{alt}, \code{ref}.
}
\description{
This function reads a standard Plink *.bim file into a tibble with named columns.
It uses \code{\link[readr:read_table]{readr::read_table()}} to do it efficiently.
}
\examples{
# to read "data.bim", run like this:
# bim <- read_bim("data")
# this also works
# bim <- read_bim("data.bim")

# The following example is more awkward
# because package sample data has to be specified in this weird way:

# read an existing Plink *.bim file
file <- system.file("extdata", 'sample.bim', package = "genio", mustWork = TRUE)
bim <- read_bim(file)
bim

# can specify without extension
file <- sub('\\\\.bim$', '', file) # remove extension from this path on purpose
file # verify .bim is missing
bim <- read_bim(file) # loads too!
bim

}
\seealso{
\code{\link[=read_plink]{read_plink()}} for reading a set of BED/BIM/FAM files.

Plink BIM format references:
\url{https://www.cog-genomics.org/plink/1.9/formats#bim}
\url{https://www.cog-genomics.org/plink/2.0/formats#bim}
}
