% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_fun_pls.treemodel.R
\name{pls.treemodel}
\alias{pls.treemodel}
\title{PLS-SEM results of terminal nodes from the Pathmox Segmentation Trees}
\usage{
pls.treemodel(
  xtree,
  terminal = TRUE,
  scaled = FALSE,
  label = FALSE,
  label.nodes = NULL,
  ...
)
}
\arguments{
\item{xtree}{An object of class \code{"xtree.pls"} returned by
\code{\link{pls.pathmox}}.}

\item{terminal}{is string, if equal to \code{TRUE}, just the terminal nodes are considered 
for the output reults. when it is equal to \code{FALSE},the PLS-PM results are generated 
for all nodes of the tree}

\item{scaled}{to standardize the latent variables or not}

\item{label}{is a string. It is false for defect. If it is \code{TRUE}, label.nodes has to be fix.}

\item{label.nodes}{is a vector with the name of the nodes. It is null for defect.}

\item{\dots}{Further arguments passed on to \code{\link{pls.treemodel}}.}
}
\value{
An object of class \code{"treemodel.pls"}. Basically a list with the
following results:

\item{weights}{Matrix of outer weights for each terminal node}

\item{loadings}{Matrix of loadings for each terminal node}

\item{path_coef}{Matrix of path coefficients for each terminal node}

\item{path_sgnificance}{Matrix of  path coefficients the significance (p-value) for each terminal node}

\item{predictive_power_R2}{Matrix of r-squared coefficients for each terminal node}

\item{total_effects}{list of matrix with the terminal effects for each terminal node}
}
\description{
Calculates basic PLS-SEM results for the terminal nodes of PATHMOX
trees
}
\details{
The argument \code{xtree} is an object of class \code{"xtree.pls"} returned by 
\code{\link{pls.pathmox}}.
}
\examples{
\dontrun{
 ## example of PLS-PM in bank customer satisfaction
 
data(csibank)

# select manifest variables
data.bank <-csibank[,6:32]

# define inner model matrix
Image 			  = rep(0,6)
Expectation	  = c(1,0,0,0,0,0)
Quality		    = c(0,1,0,0,0,0)
Value			    = c(0,1,1,0,0,0)
Satis			    = c(1,1,1,1,0,0)
Loyalty       = c(1,0,0,0,1,0)
inner.bank = rbind(Image,Expectation, Quality, Value, Satis,Loyalty)
colnames(inner.bank) = rownames(inner.bank)

# blocks of indicators (outer model)
outer.bank  = list(1:6,7:10,11:17,18:21,22:24,25:27)
modes.bank = rep("A", 6)


# re-ordering those segmentation variables with ordinal scale 
seg.bank= csibank[,1:5]

seg.bank$Age = factor(seg.bank$Age, ordered=TRUE)
seg.bank$Education = factor(seg.bank$Education, ordered=TRUE)


# Pathmox Analysis
bank.pathmox=pls.pathmox(data.bank, inner.bank, outer.bank, modes.bank,SVAR=seg.bank,signif=0.05,
                         deep=2,size=0.2,n.node=20)

nodes.models=pls.treemodel(bank.pathmox)
 
 }

}
\references{
Lamberti, G. (2021) \emph{Hybrid multigroup partial least squares structural equation modelling: 
an application to bank employee satisfaction and loyalty}. 
Quality and Quantity; doi: 10.1007/s11135-021-01096-9;

Lamberti, G. et al. (2017) \emph{The Pathmox approach for PLS path modeling: 
Discovering which constructs differentiate segments.}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2270;

Lamberti, G. et al. (2016) \emph{The Pathmox approach for PLS path modeling segmentation}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2168;

Lamberti, G. (2015) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\seealso{
\code{\link{pls.pathmox}}
}
\author{
Giuseppe Lamberti
}
