% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_function.R
\name{power.calc}
\alias{power.calc}
\title{Function to Calculate Power}
\usage{
power.calc(N = NULL, Case.Rate = NULL, k = NULL, MAF = NULL,
  OR = NULL, Alpha = 0.05, True.Model = "All", Test.Model = "All")
}
\arguments{
\item{N}{Vector of the desired sample size(s)}

\item{Case.Rate}{Vector of the proportion(s) of cases in the sample (cases/(cases + controls)). Either k or Case.Rate must be specified.}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{MAF}{Vector of minor allele frequencies}

\item{OR}{Vector of odds ratios to detect}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, OR, Power, etc)
}
\description{
Calculates the power to detect an odds ratio, OR, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
pw <- power.calc(N=2000, Case.Rate=0.5, k=NULL,
    MAF=0.2, OR=1.5,Alpha=0.05,
    True.Model='All', Test.Model='All')

}
