% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensvm.grid.R
\name{gensvm.load.small.grid}
\alias{gensvm.load.small.grid}
\title{Load the small parameter grid for the GenSVM grid search}
\usage{
gensvm.load.small.grid()
}
\description{
This function loads a small parameter grid to use for the 
GenSVM gridsearch. It contains all possible combinations of the following 
parameter sets:

\code{p = c(1.0, 1.5, 2.0)}
\code{lambda = c(1e-8, 1e-6, 1e-4, 1e-2, 1)}
\code{kappa = c(-0.9, 0.5, 5.0)}
\code{weights= c('unit', 'group')}
}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{https://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm.grid}}, \code{\link{gensvm.load.tiny.grid}}, 
\code{\link{gensvm.load.small.grid}}.
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
