% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.plot.depth}
\alias{spc.plot.depth}
\alias{spc.plot.depth,Spectra-method}
\title{Plotting \code{Spectra} object}
\usage{
spc.plot.depth(object, ...)

\S4method{spc.plot.depth}{Spectra}(
  object,
  X,
  maxSp = 10,
  lab_cex,
  title,
  add = FALSE,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  xlim = NULL,
  lwd = 2,
  ...
)
}
\arguments{
\item{object}{a \code{Spectra} data.}

\item{...}{any further arguments of plot}

\item{X}{character. Column names of the a \code{Spectra} object to be plotted.}

\item{maxSp}{numeric. Maximum number of \code{Spectra} to plot.}

\item{lab_cex}{vector of character expansion sizes, used cyclically.}

\item{title}{a chracter string, title for plot}

\item{add}{logical. If TRUE, plots are added to current one,}

\item{xlab, ylab}{titles for x and y axes, as in plot.}

\item{ylim, xlim}{ranges of x and y axes, as in plot.}

\item{lwd}{numeric vector of line widths}
}
\description{
Generating plot of the contents of a \code{Spectra} object with respect to depth
}
\examples{
x <- spc.example_spectra()
spc.plot.depth(x)

}
\seealso{
\code{\link{spc.plot}}
}
