% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{rep,Spectra-method}
\alias{rep,Spectra-method}
\title{Replicate rows of \code{Spectra} object}
\usage{
\S4method{rep}{Spectra}(x, times, ...)
}
\arguments{
\item{x}{A \code{Spectra} object whose rows are to be replicated.}

\item{times}{A integer vector giving the (non-negative) number of times to repeat each row.
See help of \code{\link{rep}}.}

\item{...}{further arguments to be passed to or from other methods. 
See help of \code{\link{rep}}.}
}
\value{
A \code{Spectra} object
}
\description{
Operators
}
\details{
Replicates rows of \code{x}, making \code{times} copies of each row. 
Replicates \code{Spectra}, \code{data}, \code{sp}, \code{time}, \code{endTime}, 
\code{InvalidIdx} slots. Resets the \code{SelectedIdx} slot.
}
\examples{
sp=spc.example_spectra()
dim(sp)
sp2 = rep(sp, 5)
dim(sp2)

}
