% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_immediate_region.R
\name{read_immediate_region}
\alias{read_immediate_region}
\title{Download spatial data of Brazil's Immediate Geographic Areas}
\usage{
read_immediate_region(
  code_immediate = "all",
  year = 2019,
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{code_immediate}{6-digit code of an immediate region. If the two-digit
code or a two-letter uppercase abbreviation of a state is passed, (e.g. 33 or
"RJ") the function will load all immediate regions of that state. If
\code{code_immediate="all"} (Default), all immediate regions of the country are
loaded.}

\item{year}{A date number in YYYY format (defaults to 2019)}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
returns the data set with original' resolution or a data set with 'simplified'
borders. Defaults to \code{TRUE}. For spatial analysis and statistics users should
set \code{simplified = FALSE}. Borders have been simplified by removing vertices of
borders using \code{sf::st_simplify()} preserving topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
The Immediate Geographic Areas are part of the geographic division of Brazil created in 2017 by IBGE. These regions
were created to replace the "Micro Regions" division. Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\dontrun{ if (interactive()) {
# Read an specific immediate region
  im <- read_immediate_region(code_immediate=110006)

# Read immediate regions of a state
  im <- read_immediate_region(code_immediate=12)
  im <- read_immediate_region(code_immediate="AM")

# Read all immediate regions of the country
  im <- read_immediate_region()
  im <- read_immediate_region(code_immediate="all")
}}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
