% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_census_tract.R
\name{read_census_tract}
\alias{read_census_tract}
\title{Download spatial data of census tracts of the Brazilian Population Census}
\usage{
read_census_tract(
  code_tract,
  year = 2010,
  zone = "urban",
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{code_tract}{The 7-digit code of a Municipality. If the two-digit code
or a two-letter uppercase abbreviation of a state is passed, (e.g. 33
or "RJ") the function will load all census tracts of that state. If
\code{code_tract="all"}, the function downloads all census tracts of the
country.}

\item{year}{Numeric. Year of the data in YYYY format. Defaults to \code{2010}.}

\item{zone}{For census tracts before 2010, 'urban' and 'rural' census tracts
are separate data sets.}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
should return the data set with 'original' spatial resolution or a data set
with 'simplified' geometry. Defaults to \code{TRUE}. For spatial analysis and
statistics users should set \code{simplified = FALSE}. Borders have been
simplified by removing vertices of borders using \verb{st_simplify\{sf\}} preserving
topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Download spatial data of census tracts of the Brazilian Population Census
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read rural census tracts for years before 2007
  c <- read_census_tract(code_tract=5201108, year=2000, zone="rural")

# Read all census tracts of a state at a given year
  c <- read_census_tract(code_tract=53, year=2010) # or
  c <- read_census_tract(code_tract="DF", year=2010)
  plot(c)

# Read all census tracts of a municipality at a given year
  c <- read_census_tract(code_tract=5201108, year=2010)
  plot(c)

# Read all census tracts of the country at a given year
  c <- read_census_tract(code_tract="all", year=2010)
\dontshow{\}) # examplesIf}
}
\seealso{
Other general area functions: 
\code{\link{read_conservation_units}()}
}
\concept{general area functions}
