% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_dens.R
\name{sim_power_dens}
\alias{sim_power_dens}
\title{Simulate power densities}
\usage{
sim_power_dens(
  target_dens,
  dens_manip,
  priorities,
  priorities_manip,
  window,
  color = c("white", "#F8DAC5FF", "#F4825AFF", "#D2204CFF", "#771F59FF"),
  grayscale = FALSE
)
}
\arguments{
\item{target_dens}{list of target densities. This should always be a list, even if there is only one target density.}

\item{dens_manip}{a target density for which we manipulate the value of priorities}

\item{priorities}{numeric. `priorities` specifies the priority for the target density that we do not manipulate.}

\item{priorities_manip}{vector of priorities for the density that we manipulate.}

\item{window}{owin object}

\item{color}{the color scale. By default, "white", "#F8DAC5FF", "#F4825AFF", "#D2204CFF", and "#771F59FF".}

\item{grayscale}{logical. `grayscale` specifies whether to convert plot to grayscale (by default, FALSE).}
}
\value{
list of densities, plot, and priorities
}
\description{
A function that takes the target densities and their priorities
and returns a power density image over a range of parameters
}
\examples{
# Density 1: Distance from Mosul
dist_from_mosul <- get_dist_focus(window = iraq_window,
                                  lon = c(43.158),
                                  lat = c(36.349),
                                  resolution = 0.5,
                                  mile = FALSE,
                                  preprocess = FALSE)

# Density 2: Distance from Baghdad
dist_from_baghd <- get_dist_focus(window = iraq_window,
                                  lon = c(44.366),
                                  lat = c(33.315),
                                  resolution = 0.5,
                                  mile = FALSE,
                                  preprocess = FALSE)

# Simulation
sim_power_dens(target_dens = list(dist_from_baghd),
               dens_manip = dist_from_mosul,
               priorities = 1,
               priorities_manip = c(1, 2, 5, 10, 15, 50),
               window = iraq_window,
               grayscale = FALSE)
}
