% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Generate a Hajek estimator}
\usage{
get_estimates(
  weighted_surf_1,
  weighted_surf_2,
  use_dist = TRUE,
  windows,
  dist_map,
  dist,
  entire_window
)
}
\arguments{
\item{weighted_surf_1}{a weighted surface for scenario 1}

\item{weighted_surf_2}{another weighted surface for scenario 2}

\item{use_dist}{whether to use distance-based maps. By default, TRUE}

\item{windows}{a list of owin objects (if `use_dist = FALSE`)}

\item{dist_map}{distance map (an im object, if `use_dist = TRUE`)}

\item{dist}{distances (a numeric vector within the max distance of `dist_map`)}

\item{entire_window}{an owin object of the entire map}
}
\value{
list of Hajek estimators for each scenario (`est_haj`), 
causal contrasts (Hajek estimator) as a matrix (`est_tau_haj_matrix`), and 
causal contrast (scenario 2 - scenario 1) as a numeric vector (`est_tau_haj_cf2_vs_cf1`), 
along with weights, windows, and smoothed outcomes
}
\description{
A function that returns a Hajek estimator of causal contrasts
}
\details{
`get_estimates()` is an internal function to `get_est()` function, 
performing the estimation analysis after `get_weighted_surf()` function
}
