% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoc_swm.R
\name{geocd_swm}
\alias{geocd_swm}
\title{constructing spatial weight matrix based on geocomplexity with spatial dependence}
\usage{
geocd_swm(sfj, wt = NULL, style = "B", ...)
}
\arguments{
\item{sfj}{An \code{sf} object or spatial vector object that can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{wt}{(optional) Spatial weight matrix based on spatial adjacency or spatial distance relationships.}

\item{style}{(optional) A character that can be \code{B},\code{W},\code{C}.  More to see \code{spdep::nb2mat()}.
Default is \code{B}.}

\item{...}{(optional) Other parameters passed to \code{geocomplexity::geocd_vector()}.}
}
\value{
A matrix
}
\description{
constructing spatial weight matrix based on geocomplexity with spatial dependence
}
\examples{
econineq = sf::read_sf(system.file('extdata/econineq.gpkg',package = 'geocomplexity'))
wt_gc = geocd_swm(econineq)
wt_gc[1:5,1:5]

}
