% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelplotXyz.r
\name{levelplotXyz}
\alias{levelplotXyz}
\title{Levelplot of XYZ Data}
\usage{
levelplotXyz(Profile, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(Profile@title, "without topography"), col = colors,
  breaks = 18, trafo = log, backtrafo = exp, ...)
}
\arguments{
\item{Profile}{profile.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{col}{vector of colors.}

\item{breaks}{number of color breaks.}

\item{trafo}{transformation to be done on data (default: log).}

\item{backtrafo}{back transformation to plot correct labels (default: exp).}

\item{...}{lattice levelplot arguments.}
}
\description{
Plots the interpolated resistance values of the xyz 
data without topography (height adjustment).
The xyz values are obtained through inversion of the raw values.
}
\examples{
# data(sinkhole)

# levelplotXyz(sinkhole@profiles[[1]])
# levelplotLegendLabel()

# levelplotXyz(sinkhole@profiles[[2]])
# levelplotLegendLabel()

# levelplotXyz(sinkhole@profiles[[3]])
# levelplotLegendLabel()
}
\seealso{
\code{\link{XyzData-class}}, \code{\link{levelplotXyzHeight}},
\code{\link{levelplotRaw}}
}

