% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_docs.R
\docType{data}
\name{grids}
\alias{grids}
\alias{us_state_grid1}
\alias{us_state_grid2}
\alias{eu_grid1}
\alias{aus_grid1}
\alias{sa_prov_grid1}
\alias{london_boroughs_grid}
\alias{nhs_scot_grid}
\alias{india_grid1}
\alias{india_grid2}
\alias{argentina_grid1}
\alias{br_grid1}
\title{Geo Grids}
\usage{
us_state_grid1

us_state_grid2

eu_grid1

aus_grid1

sa_prov_grid1

london_boroughs_grid

nhs_scot_grid

india_grid1

india_grid2

argentina_grid1

br_grid1
}
\description{
See \code{\link{facet_geo}} for several examples.

\strong{us_state_grid1:} Grid layout for US states (including DC) Image reference \href{https://images7.alphacoders.com/687/687665.jpg}{here}.

\strong{us_state_grid2:} Grid layout for US states (including DC) Image reference \href{https://images7.alphacoders.com/687/687665.jpg}{here}.

\strong{eu_grid1:} Grid layout for the 28 EU Countries Image reference \href{https://ichef.bbci.co.uk/news/660/media/images/70233000/gif/_70233868_eunames.gif}{here}.

\strong{aus_grid1:} Grid layout for the Australian States and Territories. Image reference \href{https://cloud.githubusercontent.com/assets/9496865/26334627/75a729d2-3fa5-11e7-88af-a1dd86b7ddf3.png}{here}. Thanks to \url{https://github.com/jonocarroll}.

\strong{sa_prov_grid1:} Grid layout for the provinces of South Africa Image reference \href{https://camo.githubusercontent.com/a90b18a1ab0c36200da9b118141b997b3f22638e/687474703a2f2f7777772e6578706c6f7265736f7574686166726963612e6e65742f696d616765732f70726f766d61702e6a7067}{here}. Thanks to \url{https://github.com/jonmcalder}.

\strong{london_boroughs_grid:} Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the \href{http://geoportal.statistics.gov.uk/datasets/464be6191a434a91a5fa2f52c7433333_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference \href{https://cloud.githubusercontent.com/assets/13021448/26399784/3133d684-4076-11e7-8eac-1e74d023bf18.jpg}{here}. Thanks to \url{https://github.com/eldenvo}.

\strong{nhs_scot_grid:} Grid layout for a grid of National Health Service (NHS) Scotland Health Boards. Note that the column \code{code} contains the \href{http://geoportal.statistics.gov.uk/datasets/61dca36aa33e4aee99bbfa784fa9eb25_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference \href{https://cloud.githubusercontent.com/assets/24879214/26426113/253658d0-40cf-11e7-88b5-fe5ee7fda44f.png}{here}. Thanks to \url{https://github.com/josephjosephadams}.

\strong{india_grid1:} Grid layout for India states (not including union territories). Image reference \href{https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg}{here}. Thanks to \url{https://github.com/meysubb}.

\strong{india_grid2:} Grid layout for India states (not including union territories). Image reference \href{https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg}{here}.

\strong{argentina_grid1:} Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations). Image reference \href{https://s-media-cache-ak0.pinimg.com/736x/bf/cb/96/bfcb9654477c127d3b0e0b72d5be65fc.jpg}{here}. Thanks to \url{https://github.com/eliocamp}.

\strong{br_grid1:} Grid for the 27 states of Brazil. Image reference \href{https://camo.githubusercontent.com/477627dce2610f18f1bf3850cd32fca01610656e/687474703a2f2f63656a656475696e66616e74696c2e7062776f726b732e636f6d2f662f313435383034313938342f4d61706142726173696c5369676c61732e676966}{here}. Thanks to \url{https://github.com/italocegatta}.
}
\keyword{data}
