# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title Encode Latitude and Longitude Values
#'@description \code{\link{gh_encode}} generates geohashes of a
#'given precision from vectors of latitude and longitude values.
#'
#'@param lats a numeric vector of latitude values.
#'
#'@param lngs a numeric vector of longitude values. Must be the same length
#'as \code{lat}.
#'
#'@param precision an integer representing the precision the hashes should have.
#'This should be between 1 and 10; if the precision requested is greater than 10, it will
#'use 10 - if less than 1, it will error.
#'
#'@return a character vector of hashes, the same length as \code{lat} and \code{lng},
#'with \code{NA} values where one of the equivalent lat/lng pair was NA.
#'
#'@examples
#'# A simple example:
#'gh_encode(lat = 42.60498046875, lng = -5.60302734375, precision = 5)
#'#[1] "ezs42"
#'
#'@seealso \code{\link{gh_decode}}, for taking geohashes and turning them back into coordinates,
#'and \code{\link{gh_neighbours}} for retrieving the neighbouring hashes to a particular hash.
#'
#'@export
gh_encode <- function(lats, lngs, precision = 6L) {
    .Call(`_geohash_gh_encode`, lats, lngs, precision)
}

#'@title Decode Geohashes
#'@description \code{gh_decode} takes geohashes and turns them back into
#'latitude/longitude pairs, with an associated margin of error for each value.
#'
#'@param hashes a character vector of geohashes.
#'
#'@return a data.frame of four columns; "lat", "lng", "lat_error" and "lng_error"
#'
#'@seealso \code{\link{gh_encode}} for generating geohashes, and
#'\code{\link{gh_neighbours}} for identifying the neighbouring hash boxes
#'to a geohash.
#'
#'@examples
#'# A simple example:
#'gh_encode(lat = 42.60498046875, lng = -5.60302734375, precision = 5)
#'#[1] "ezs42"
#'
#'gh_decode("ezs42")
#'# lat      lng      lat_error  lng_error
#'# 42.60498 -5.603027 0.02197266 0.02197266
#'@export
gh_decode <- function(hashes) {
    .Call(`_geohash_gh_decode`, hashes)
}

#'@rdname neighbours
#'@export
gh_neighbours <- function(hashes) {
    .Call(`_geohash_gh_neighbours`, hashes)
}

gh_neighbour <- function(hashes, direction) {
    .Call(`_geohash_gh_neighbour`, hashes, direction)
}

