% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{geojson_write.SpatialRings}
\alias{geojson_write.SpatialRings}
\alias{geojson_write.SpatialRingsDataFrame}
\alias{geojson_write.SpatialCollections}
\title{Deprecated functions from geojsonio}
\usage{
\method{geojson_write}{SpatialRings}(
  input,
  lat = NULL,
  lon = NULL,
  geometry = "point",
  group = NULL,
  file = "myfile.geojson",
  overwrite = TRUE,
  precision = NULL,
  convert_wgs84 = FALSE,
  crs = NULL,
  ...
)

\method{geojson_write}{SpatialRingsDataFrame}(
  input,
  lat = NULL,
  lon = NULL,
  geometry = "point",
  group = NULL,
  file = "myfile.geojson",
  overwrite = TRUE,
  precision = NULL,
  convert_wgs84 = FALSE,
  crs = NULL,
  ...
)

\method{geojson_write}{SpatialCollections}(
  input,
  lat = NULL,
  lon = NULL,
  geometry = "point",
  group = NULL,
  file = "myfile.geojson",
  overwrite = TRUE,
  precision = NULL,
  convert_wgs84 = FALSE,
  crs = NULL,
  ...
)
}
\arguments{
\item{input}{Input list, data.frame, spatial class, or sf class.
Inputs can  also be dplyr \code{tbl_df} class since it inherits
from \code{data.frame}}

\item{lat}{(character) Latitude name. The default is \code{NULL}, and we
attempt to guess.}

\item{lon}{(character) Longitude name. The default is \code{NULL}, and we
attempt to guess.}

\item{geometry}{(character) One of point (Default) or polygon.}

\item{group}{(character) A grouping variable to perform grouping for
polygons - doesn't apply for points}

\item{file}{(character) A path and file name (e.g., myfile), with the
\code{.geojson} file extension. Default writes to current working
directory.}

\item{overwrite}{(logical) Overwrite the file given in \code{file} with
\code{input}. Default: \code{TRUE}. If this param is \code{FALSE} and
the file already exists, we stop with error message.}

\item{precision}{desired number of decimal places for the coordinates in the
geojson file. Using fewer decimal places can decrease file sizes (at the
cost of precision).}

\item{convert_wgs84}{Should the input be converted to the
standard CRS for GeoJSON (https://tools.ietf.org/html/rfc7946)
(geographic coordinate reference
system, using the WGS84 datum, with longitude and latitude units of decimal
degrees; EPSG: 4326). Default is \code{FALSE} though this may change in a
future package version. This will only work for \code{sf} or \code{Spatial}
objects with a CRS already defined. If one is not defined but you know what
it is, you may define it in the \code{crs} argument below.}

\item{crs}{The CRS of the input if it is not already defined. This can be
an epsg code as a four or five digit integer or a valid proj4 string. This
argument will be ignored if \code{convert_wgs84} is \code{FALSE} or the
object already has a CRS.}

\item{...}{Further args passed on to internal functions. For Spatial*
classes, data.frames,
regular lists, and numerics, it is passed through to
\code{\link[sf:st_write]{sf::st_write()}}. For sf classes,
geo_lists and json classes, it is passed through to
\code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
Due to the retirement of rgeos and maptools in 2023, the following functions
are now deprecated and provide warnings on use. They will error beginning in
early 2023 and then be removed entirely in the future.

At the moment, there is no replacement for these functions that uses the
newer geos package (or any alternative for maptools). If you'd be interested
in contributing replacements, please feel free to contribute a pull request!
}
\examples{
\dontrun{
# From SpatialRings
library(rgeos)
r1 <- Ring(cbind(x = c(1, 1, 2, 2, 1), y = c(1, 2, 2, 1, 1)), ID = "1")
r2 <- Ring(cbind(x = c(1, 1, 2, 2, 1), y = c(1, 2, 2, 1, 1)), ID = "2")
r1r2 <- SpatialRings(list(r1, r2))
geojson_write(r1r2)

# From SpatialRingsDataFrame
dat <- data.frame(id = c(1, 2), value = 3:4)
r1r2df <- SpatialRingsDataFrame(r1r2, data = dat)
geojson_write(r1r2df)

# From SpatialCollections
library("sp")
poly1 <- Polygons(list(Polygon(cbind(c(-100, -90, -85, -100), c(40, 50, 45, 40)))), "1")
poly2 <- Polygons(list(Polygon(cbind(c(-90, -80, -75, -90), c(30, 40, 35, 30)))), "2")
poly <- SpatialPolygons(list(poly1, poly2), 1:2)
coordinates(us_cities) <- ~ long + lat
dat <- SpatialCollections(points = us_cities, polygons = poly)
geojson_write(dat)
}

}
