% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/02-webgeom-obj.R
\docType{methods}
\name{webgeom}
\alias{webgeom}
\alias{webgeom,ANY-method}
\alias{webgeom,missing-method}
\title{create webgeom object}
\usage{
webgeom(.Object, ...)

\S4method{webgeom}{missing}(.Object, ...)

\S4method{webgeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{webgeom}}

\item{...}{additional arguments passed initialize method (e.g., \code{url})}
}
\value{
the webgeom object representing a dataset and parameters
}
\description{
A class representing a web dataset.
}
\section{Slots}{

\describe{
\item{\code{url}}{value of type \code{"character"}, the web location for the dataset}

\item{\code{variable}}{value of type \code{"character"}, the variable(s) for data}
}}
\examples{
wg <- webgeom(geom = "sample:CONUS_states",
 attribute = "STATE",
 values = "New Hampshire")
#-- use available state datasets:
wg <- webgeom('state::New Hampshire')
wg <- webgeom('state::New Hampshire,Wisconsin,Alabama')
#-- use available Level III Ecoregion datasets:
wg <- webgeom('ecoregion::Colorado Plateaus,Driftless Area')
#-- use available simplified HUC8s:
wg <- webgeom('HUC8::09020306,14060009')
wg <- webgeom()
}
\author{
Jordan S Read
}

