% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISODataQualityAbstractElement.R
\docType{class}
\name{ISODataQualityAbstractElement}
\alias{ISODataQualityAbstractElement}
\title{ISODataQualityAbstractElement}
\format{\code{\link{R6Class}} object.}
\usage{
ISODataQualityAbstractElement
}
\value{
Object of \code{\link{R6Class}} for modelling an ISODataQualityAbstractElement
}
\description{
ISODataQualityAbstractElement
}
\section{Fields}{

\describe{
\item{\code{nameOfMeasure}}{}

\item{\code{measureIdentification}}{}

\item{\code{measureDescription}}{}

\item{\code{evaluationMethodType}}{}

\item{\code{evaluationMethodDescription}}{}

\item{\code{evaluationProcedure}}{}

\item{\code{dateTime}}{}

\item{\code{result}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISODataQuality
 }
 \item{\code{addNameOfMeasure(name)}}{
   Add name
 }
 \item{\code{delNameOfMeasure(name)}}{
   Deletes name
 }
 \item{\code{setMeasureIdentification(identification)}}{
   Sets measure identifier, an object of class \code{ISOMetaIdentifier}
 }
 \item{\code{setMeasureDescription(description)}}{
   Sets measure description
 }
 \item{\code{setEvaluationMethodType(type)}}{
   Sets the type of evaluation method, an object of class \code{ISOEvaluationMethodType}
   or any \code{character} value among code{ISOEvaluationMethodType$values()}
 }
 \item{\code{setEvaluationMethodDescription(description)}}{
   Sets the description of evaluation method
 }
 \item{\code{setEvaluationMethodProcedure(procedure)}}{
   Sets the procedure as an object of class \code{ISOCitation}
 }
 \item{\code{setDateTime(dateTime)}}{
   Sets datetime, object class 'POSIXct'/'POSIXt'
 }
 \item{\code{addResult(result)}}{
   Sets conformance result, object of class \code{ISOConformanceResult}
 }
 \item{\code{delResult(result)}}{
   Deletes conformance result, object of class \code{ISOConformanceResult}
 }
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{abstract}
\keyword{data}
\keyword{element}
\keyword{quality}

