% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOResponsibleParty.R
\docType{class}
\name{ISOResponsibleParty}
\alias{ISOResponsibleParty}
\title{ISOResponsibleParty}
\format{\code{\link{R6Class}} object.}
\usage{
ISOResponsibleParty
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ResponsibleParty
}
\description{
ISOResponsibleParty
}
\section{Fields}{

\describe{
\item{\code{value}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an ISOResponsibleParty
 }
}
}
\examples{
#create a responsible party element
  md <- ISOResponsibleParty$new()
  md$setIndividualName("someone")
  md$setOrganisationName("somewhere")
  md$setPositionName("someposition")
  md$setRole("pointOfContact")

  #add contact
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  md$setContactInfo(contact)

  xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{file}
\keyword{identifier}

