% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOSource.R
\docType{class}
\name{ISOSource}
\alias{ISOSource}
\title{ISOSource}
\format{\code{\link{R6Class}} object.}
\usage{
ISOSource
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Source
}
\description{
ISOSource
}
\section{Fields}{

\describe{
\item{\code{description}}{}

\item{\code{scaleDenominator}}{}

\item{\code{sourceReferenceSystem}}{}

\item{\code{sourceCitation}}{}

\item{\code{sourceExtent}}{}

\item{\code{sourceStep}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOSource
 }
 \item{\code{setDescription(description)}}{
   Sets the source description
 }
 \item{\code{setScaleDenominator(denominator)}}{
   Sets the scale denominator (object of class \code{ISORepresentativeFraction} or
   an integer value or other value coercable to integer)
 }
 \item{\code{setReferenceSystem(referenceSystem)}}{
   Sets the source reference system (object of class \code{ISOReferenceSystem})
 }
 \item{\code{setCitation(citation)}}{
   Sets the source citation (object of class \code{ISOCitation})
 }
 \item{\code{addExtent(extent)}}{
   Adds the source extent (object of class \code{ISOExtent})
 }
 \item{\code{delExtent(extent)}}{
   Deletes a source extent
 }
 \item{\code{addProcessStep(processStep)}}{
   Adds a source process step (object of class \code{ISOProcessStep})
 }
 \item{\code{delProcessStep(processStep)}}{
   Deletes a source processStep
 }
}
}
\examples{
src <- ISOSource$new()
  src$setDescription("description")
  src$setScaleDenominator(1L)

  rs <- ISOReferenceSystem$new()
  rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
  rs$setReferenceSystemIdentifier(rsId)
  src$setReferenceSystem(rs)

  cit <- ISOCitation$new()
  cit$setTitle("sometitle") #and more citation properties...
  src$setCitation(cit)

  extent <- ISOExtent$new()
  bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
  extent$setGeographicElement(bbox)
  src$addExtent(extent)
  xml <- src$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{source}

