% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOExtendedElementInformation.R
\docType{class}
\name{ISOExtendedElementInformation}
\alias{ISOExtendedElementInformation}
\title{ISOExtendedElementInformation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOExtendedElementInformation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ExtendedElementInformation
}
\description{
ISOExtendedElementInformation
}
\section{Fields}{

\describe{
\item{\code{source}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOExtendedElementInformation
 }
 \item{\code{setName(name)}}{
   Sets the element name, object of class \code{Character}
 }
 \item{\code{setShortName(shortName)}}{
   Sets the element shortname, object of class \code{character}
 }
 \item{\code{setDomainCode(domainCode)}}{
   Sets the element domain code, object of class \code{integer}
 }
 \item{\code{setDefinition(definition)}}{
   Sets the element definition, object of class \code{character}
 }
 \item{\code{setObligation(obligation)}}{
   Sets an obligation, as object of class \code{character} or class \code{ISOObligation}. 
   If an object of class "character" is specified, it must match the accepted
   obligation values \code{ISOObligation$values()}.
 }
 \item{\code{setCondition(condition)}}{
   Sets the element condition, object of class \code{character}
 }
 \item{\code{setDatatype(dataType)}}{
   Sets the element datatype, as object of class \code{character} or class \code{ISODatatype}.
   If an object of class "character" is specified, it must match the accepted
   datatype values \code{ISODatatype$values()}.
 }
 \item{\code{setMaximumOccurrrence(maximumOccurrence)}}{
   Sets the element maximum occurrence, object of class \code{character}
 }
 \item{\code{setDomainValue(domainValue)}}{
   Sets the element domain value, object of class \code{character}
 }
 \item{\code{addParentyEntity(parentEntity)}}{
   Adds a parent Entity, object of class \code{character}
 }
 \item{\code{delParentEntity(parentEntity)}}{
   Deletes a parent Entity, object of class \code{character}
 }
 \item{\code{setRule(rule)}}{
   Sets a rule, object of class \code{character}
 }
 \item{addRationale(rationale)}{
   Adds a rationale, object of class \code{character}
 }
 \item{delRationale(rationale)}{
   Deletes a rationale, object of class \code{character}
 }
 \item{addSource(source)}{
   Adds a source, object of class \code{ISOResponsibleParty}
 }
 \item{delSource(source)}{
   Deletes a source, object of class \code{ISOResponsibleParty}
 }
}
}

\examples{
  md <- ISOExtendedElementInformation$new()
  md$setName("name")
  md$setShortName("shortName")
  md$setDomainCode(1L)
  md$setDefinition("some definition")
  md$setObligation("mandatory")
  md$setCondition("no condition")
  md$setDatatype("characterString")
  md$setMaximumOccurrence("string")
  md$setDomainValue("value")
  md$addParentEntity("none")
  md$setRule("rule")
  md$addRationale("rationale")
  
  #adding a source
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone")
  rp$setOrganisationName("somewhere")
  rp$setPositionName("someposition")
  rp$setRole("pointOfContact")
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  rp$setContactInfo(contact)
  
  md$addSource(rp)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{element}
\keyword{extended}
\keyword{information}
