% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOSecurityConstraints.R
\docType{class}
\name{ISOSecurityConstraints}
\alias{ISOSecurityConstraints}
\title{ISOSecurityConstraints}
\format{\code{\link{R6Class}} object.}
\usage{
ISOSecurityConstraints
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO SecurityConstraints
}
\description{
ISOSecurityConstraints
}
\section{Fields}{

\describe{
\item{\code{classification}}{[\code{\link{ISOClassification}}] security classifciation}

\item{\code{userNote}}{[\code{\link{character}}] user note}

\item{\code{classificationSystem}}{[\code{\link{character}}] classification system}

\item{\code{handlingDescription}}{[\code{\link{character}}] description}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOSecurityConstraints
 }
 \item{\code{setClassification(classification)}}{
   Adds a classification, as object of class "character" or class \code{\link{ISOClassification}}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISOClassification$values()}.
 }
 \item{\code{setUserNote(userNote, locales)}}{
   Sets a user note as object of class "character". Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setClassificationSystem(classificationSystem, locales)}}{
   Sets a classification system as object of class "character". Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setHandlingDescription(handlingDescription, locales)}}{
   Sets a handling description as object of class "character". Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
   #create object
   md <- ISOSecurityConstraints$new()
   md$setClassification("secret")
   md$setUserNote("ultra secret")
   md$setClassificationSystem("no classification in particular")
   md$setHandlingDescription("description")
   
   xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{constraints}
\keyword{security}
