% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureOperation.R
\docType{class}
\name{ISOFeatureOperation}
\alias{ISOFeatureOperation}
\title{ISOFeatureOperation}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOFeatureOperation
}
\description{
ISOFeatureOperation
}
\section{Fields}{

\describe{
\item{\code{signature}}{[\code{\link{character}}]}

\item{\code{formalDefinition}}{[\code{\link{character}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOFeatureOperation
 }
 \item{\code{setSignature(signature, locales)}}{
   Sets the signature. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setFormalDefinition(formalDefinition, locales)}}{
   Sets the formal definition. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
}
}

\examples{
  md <- ISOFeatureOperation$new()
  md$setMemberName("name")
  md$setDefinition("definition")
  md$setCardinality(lower=1,upper=1)
  md$setSignature("signature")
  md$setFormalDefinition("def")
 
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{feature}
\keyword{operation}
