% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOContact.R
\docType{class}
\name{ISOContact}
\alias{ISOContact}
\title{ISOContact}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO Contact
}
\description{
ISOContact

ISOContact
}
\examples{
 md <- ISOContact$new()
 phone <- ISOTelephone$new()
 phone$setVoice("myphonenumber")
 phone$setFacsimile("myfacsimile")
 md$setPhone(phone)
 address <- ISOAddress$new()
 address$setDeliveryPoint("theaddress")
 address$setCity("thecity")
 address$setPostalCode("111")
 address$setCountry("France")
 address$setEmail("someone@theorg.org")
 md$setAddress(address)
 res <- ISOOnlineResource$new()
 res$setLinkage("http://www.somewhereovertheweb.org")
 res$setName("somename")
 md$setOnlineResource(res)
 xml <- md$encode()
 
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_CI_Contact}
 
 - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/cit/2.0/cit/#element_CI_Contact}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{contact}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{ISOContact}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{phone}}{phone}

\item{\code{address}}{address}

\item{\code{onlineResource}}{online resource}

\item{\code{hoursOfService}}{hours of service}

\item{\code{contactInstructions}}{contact instructions}

\item{\code{contactType}}{contact type}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOContact-new}{\code{ISOContact$new()}}
\item \href{#method-ISOContact-setPhone}{\code{ISOContact$setPhone()}}
\item \href{#method-ISOContact-addPhone}{\code{ISOContact$addPhone()}}
\item \href{#method-ISOContact-delPhone}{\code{ISOContact$delPhone()}}
\item \href{#method-ISOContact-setAddress}{\code{ISOContact$setAddress()}}
\item \href{#method-ISOContact-addAddress}{\code{ISOContact$addAddress()}}
\item \href{#method-ISOContact-delAddress}{\code{ISOContact$delAddress()}}
\item \href{#method-ISOContact-setOnlineResource}{\code{ISOContact$setOnlineResource()}}
\item \href{#method-ISOContact-addOnlineResource}{\code{ISOContact$addOnlineResource()}}
\item \href{#method-ISOContact-delOnlineResource}{\code{ISOContact$delOnlineResource()}}
\item \href{#method-ISOContact-addHoursOfService}{\code{ISOContact$addHoursOfService()}}
\item \href{#method-ISOContact-delHoursOfService}{\code{ISOContact$delHoursOfService()}}
\item \href{#method-ISOContact-setContactInstructions}{\code{ISOContact$setContactInstructions()}}
\item \href{#method-ISOContact-setContactType}{\code{ISOContact$setContactType()}}
\item \href{#method-ISOContact-clone}{\code{ISOContact$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-setPhone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-setPhone}{}}}
\subsection{Method \code{setPhone()}}{
Set phone (with ISO 19139)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$setPhone(phone)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{phone}}{object of class \link{ISOTelephone}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-addPhone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-addPhone}{}}}
\subsection{Method \code{addPhone()}}{
Adds phone (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$addPhone(phone)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{phone}}{object tof class \link{ISOTelephone}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-delPhone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-delPhone}{}}}
\subsection{Method \code{delPhone()}}{
Deletes phone (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$delPhone(phone)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{phone}}{object tof class \link{ISOTelephone}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-setAddress"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-setAddress}{}}}
\subsection{Method \code{setAddress()}}{
Set address (with ISO 19139)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$setAddress(address)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{address}}{object of class \link{ISOAddress}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-addAddress"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-addAddress}{}}}
\subsection{Method \code{addAddress()}}{
Adds address (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$addAddress(address)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{address}}{object of class \link{ISOAddress}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-delAddress"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-delAddress}{}}}
\subsection{Method \code{delAddress()}}{
Deletes address (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$delAddress(address)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{address}}{object of class \link{ISOAddress}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-setOnlineResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-setOnlineResource}{}}}
\subsection{Method \code{setOnlineResource()}}{
Set online resource (with ISO 19139)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$setOnlineResource(onlineResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onlineResource}}{online resource, object of class \link{ISOOnlineResource}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-addOnlineResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-addOnlineResource}{}}}
\subsection{Method \code{addOnlineResource()}}{
Adds online resource (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$addOnlineResource(onlineResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onlineResource}}{online resource, object of class \link{ISOOnlineResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-delOnlineResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-delOnlineResource}{}}}
\subsection{Method \code{delOnlineResource()}}{
Deletes online resource (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$delOnlineResource(onlineResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onlineResource}}{online resource, object of class \link{ISOOnlineResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-addHoursOfService"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-addHoursOfService}{}}}
\subsection{Method \code{addHoursOfService()}}{
Adds hours of service (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$addHoursOfService(hoursOfService)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hoursOfService}}{object of class \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-delHoursOfService"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-delHoursOfService}{}}}
\subsection{Method \code{delHoursOfService()}}{
Deletes hours of service (with ISO 19115-3)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$delHoursOfService(hoursOfService)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hoursOfService}}{object of class \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-setContactInstructions"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-setContactInstructions}{}}}
\subsection{Method \code{setContactInstructions()}}{
Set contact instructions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$setContactInstructions(contactInstructions, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contactInstructions}}{contact instructions}

\item{\code{locales}}{list of localized editions. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-setContactType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-setContactType}{}}}
\subsection{Method \code{setContactType()}}{
Set contact type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$setContactType(contactType, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contactType}}{contact type}

\item{\code{locales}}{list of localized editions. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOContact-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOContact-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOContact$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
