% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOApplicationSchemaInformation.R
\docType{class}
\name{ISOApplicationSchemaInformation}
\alias{ISOApplicationSchemaInformation}
\title{ISOApplicationSchemaInformation}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO ApplicationSchemaInformation
}
\description{
ISOApplicationSchemaInformation

ISOApplicationSchemaInformation
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_MD_ApplicationSchemaInformation}
 
 - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mas/1.0/mas/#element_MD_ApplicationSchemaInformation}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{application}
\keyword{information}
\keyword{schema}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{ISOApplicationSchemaInformation}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{name [1..1]}

\item{\code{schemaLanguage}}{chemaLanguage [1..1]}

\item{\code{constraintLanguage}}{constraintLanguage [1..1]}

\item{\code{schemaAscii}}{schemaAscii [0..1]}

\item{\code{graphicsFile}}{graphicsFile [0..1]: ISOOnlineResource}

\item{\code{softwareDevelopmentFile}}{softwareDevelopmentFile [0..1]: ISOOnlineResource}

\item{\code{softwareDevelopmentFileFormat}}{softwareDevelopmentFileFormat [0..1]}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOApplicationSchemaInformation-new}{\code{ISOApplicationSchemaInformation$new()}}
\item \href{#method-ISOApplicationSchemaInformation-setName}{\code{ISOApplicationSchemaInformation$setName()}}
\item \href{#method-ISOApplicationSchemaInformation-setSchemaLanguage}{\code{ISOApplicationSchemaInformation$setSchemaLanguage()}}
\item \href{#method-ISOApplicationSchemaInformation-setConstraintLanguage}{\code{ISOApplicationSchemaInformation$setConstraintLanguage()}}
\item \href{#method-ISOApplicationSchemaInformation-setSchemaAscii}{\code{ISOApplicationSchemaInformation$setSchemaAscii()}}
\item \href{#method-ISOApplicationSchemaInformation-setGraphicsFile}{\code{ISOApplicationSchemaInformation$setGraphicsFile()}}
\item \href{#method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFile}{\code{ISOApplicationSchemaInformation$setSoftwareDevelopmentFile()}}
\item \href{#method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFileFormat}{\code{ISOApplicationSchemaInformation$setSoftwareDevelopmentFileFormat()}}
\item \href{#method-ISOApplicationSchemaInformation-clone}{\code{ISOApplicationSchemaInformation$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setName"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setSchemaLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setSchemaLanguage}{}}}
\subsection{Method \code{setSchemaLanguage()}}{
Set schema language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setSchemaLanguage(schemaLanguage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schemaLanguage}}{schema language}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setConstraintLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setConstraintLanguage}{}}}
\subsection{Method \code{setConstraintLanguage()}}{
Set constraint language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setConstraintLanguage(constraintLanguage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{constraintLanguage}}{constraint language}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setSchemaAscii"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setSchemaAscii}{}}}
\subsection{Method \code{setSchemaAscii()}}{
Set schema Ascii
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setSchemaAscii(schemaAscii)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schemaAscii}}{schema Ascii}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setGraphicsFile"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setGraphicsFile}{}}}
\subsection{Method \code{setGraphicsFile()}}{
Set graphics file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setGraphicsFile(graphicsFile)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicsFile}}{graphics file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFile"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFile}{}}}
\subsection{Method \code{setSoftwareDevelopmentFile()}}{
Set software development file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setSoftwareDevelopmentFile(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFileFormat"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-setSoftwareDevelopmentFileFormat}{}}}
\subsection{Method \code{setSoftwareDevelopmentFileFormat()}}{
Set software development file format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$setSoftwareDevelopmentFileFormat(format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{file format}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOApplicationSchemaInformation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOApplicationSchemaInformation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOApplicationSchemaInformation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
