% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_scale.R
\name{gt_scale}
\alias{gt_scale}
\title{Scale geometric objects}
\usage{
gt_scale(obj, range = NULL, fid = NULL, update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to be scaled.}

\item{range}{[\code{data.frame(2)}]\cr vector of length two for both of the
\code{x} and \code{y} dimension to which the values should be scaled.}

\item{fid}{[\code{integerish(.)}]\cr if only a subset of features shall be
scaled, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after scaling.}
}
\value{
\code{geom} of the scaled \code{obj}.
}
\description{
Scale the vertex values of geometric objects to a values range.
}
\examples{
# rescale to values between -10 and 10
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_scale(obj = gtGeoms$polygon, update = FALSE,
                    range = data.frame(x = c(-10, 10), y = c(-10, 10)))
visualise(geom = newPoly, linecol = "green", new = FALSE)

# rescale a single feature
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_scale(obj = gtGeoms$polygon, update = FALSE, fid = 2,
                    range = data.frame(x = c(-10, 10), y = c(-10, 10)))
visualise(geom = newPoly, linecol = "green", new = FALSE)
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
