% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSDatastoreManager.R
\docType{class}
\name{GSDataStoreManager}
\alias{GSDataStoreManager}
\title{Geoserver REST API DataStore Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer
DataStores (i.e. stores of vector data)
}
\description{
Geoserver REST API DataStore Manager

Geoserver REST API DataStore Manager
}
\examples{
\dontrun{
   GSDataStoreManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSDataStoreManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-getDataStores}{\code{GSDataStoreManager$getDataStores()}}
\item \href{#method-getDataStoreNames}{\code{GSDataStoreManager$getDataStoreNames()}}
\item \href{#method-getDataStore}{\code{GSDataStoreManager$getDataStore()}}
\item \href{#method-createDataStore}{\code{GSDataStoreManager$createDataStore()}}
\item \href{#method-updateDataStore}{\code{GSDataStoreManager$updateDataStore()}}
\item \href{#method-deleteDataStore}{\code{GSDataStoreManager$deleteDataStore()}}
\item \href{#method-getFeatureTypes}{\code{GSDataStoreManager$getFeatureTypes()}}
\item \href{#method-getFeatureTypeNames}{\code{GSDataStoreManager$getFeatureTypeNames()}}
\item \href{#method-getFeatureType}{\code{GSDataStoreManager$getFeatureType()}}
\item \href{#method-createFeatureType}{\code{GSDataStoreManager$createFeatureType()}}
\item \href{#method-updateFeatureType}{\code{GSDataStoreManager$updateFeatureType()}}
\item \href{#method-deleteFeatureType}{\code{GSDataStoreManager$deleteFeatureType()}}
\item \href{#method-publishLayer}{\code{GSDataStoreManager$publishLayer()}}
\item \href{#method-unpublishLayer}{\code{GSDataStoreManager$unpublishLayer()}}
\item \href{#method-uploadData}{\code{GSDataStoreManager$uploadData()}}
\item \href{#method-uploadShapefile}{\code{GSDataStoreManager$uploadShapefile()}}
\item \href{#method-uploadProperties}{\code{GSDataStoreManager$uploadProperties()}}
\item \href{#method-uploadH2}{\code{GSDataStoreManager$uploadH2()}}
\item \href{#method-uploadSpatialite}{\code{GSDataStoreManager$uploadSpatialite()}}
\item \href{#method-uploadAppschema}{\code{GSDataStoreManager$uploadAppschema()}}
\item \href{#method-uploadGeoPackage}{\code{GSDataStoreManager$uploadGeoPackage()}}
\item \href{#method-clone}{\code{GSDataStoreManager$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect">}\href{../../geosapi/html/GSManager.html#method-connect}{\code{geosapi::GSManager$connect()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR">}\href{../../geosapi/html/GSManager.html#method-ERROR}{\code{geosapi::GSManager$ERROR()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName">}\href{../../geosapi/html/GSManager.html#method-getClassName}{\code{geosapi::GSManager$getClassName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager">}\href{../../geosapi/html/GSManager.html#method-getCoverageStoreManager}{\code{geosapi::GSManager$getCoverageStoreManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager">}\href{../../geosapi/html/GSManager.html#method-getDataStoreManager}{\code{geosapi::GSManager$getDataStoreManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager">}\href{../../geosapi/html/GSManager.html#method-getNamespaceManager}{\code{geosapi::GSManager$getNamespaceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager">}\href{../../geosapi/html/GSManager.html#method-getServiceManager}{\code{geosapi::GSManager$getServiceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager">}\href{../../geosapi/html/GSManager.html#method-getStyleManager}{\code{geosapi::GSManager$getStyleManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus">}\href{../../geosapi/html/GSManager.html#method-getSystemStatus}{\code{geosapi::GSManager$getSystemStatus()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl">}\href{../../geosapi/html/GSManager.html#method-getUrl}{\code{geosapi::GSManager$getUrl()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager">}\href{../../geosapi/html/GSManager.html#method-getWorkspaceManager}{\code{geosapi::GSManager$getWorkspaceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO">}\href{../../geosapi/html/GSManager.html#method-INFO}{\code{geosapi::GSManager$INFO()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize">}\href{../../geosapi/html/GSManager.html#method-initialize}{\code{geosapi::GSManager$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger">}\href{../../geosapi/html/GSManager.html#method-logger}{\code{geosapi::GSManager$logger()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor">}\href{../../geosapi/html/GSManager.html#method-monitor}{\code{geosapi::GSManager$monitor()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload">}\href{../../geosapi/html/GSManager.html#method-reload}{\code{geosapi::GSManager$reload()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN">}\href{../../geosapi/html/GSManager.html#method-WARN}{\code{geosapi::GSManager$WARN()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDataStores"></a>}}
\if{latex}{\out{\hypertarget{method-getDataStores}{}}}
\subsection{Method \code{getDataStores()}}{
Get the list of available dataStores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStores(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSAbstractDataStore}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDataStoreNames"></a>}}
\if{latex}{\out{\hypertarget{method-getDataStoreNames}{}}}
\subsection{Method \code{getDataStoreNames()}}{
Get the list of available dataStore names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStoreNames(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-getDataStore}{}}}
\subsection{Method \code{getDataStore()}}{
Get an object of class \code{\link{GSAbstractDataStore}} given a workspace and datastore names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStore(ws, ds)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the datastore
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-createDataStore}{}}}
\subsection{Method \code{createDataStore()}}{
Creates a datastore given a workspace and an object of class \code{\link{GSAbstractDataStore}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$createDataStore(ws, dataStore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{dataStore}}{datastore object of class \link{GSAbstractDataStore}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-updateDataStore}{}}}
\subsection{Method \code{updateDataStore()}}{
Updates a datastore given a workspace and an object of class \code{\link{GSAbstractDataStore}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$updateDataStore(ws, dataStore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{dataStore}}{datastore object of class \link{GSAbstractDataStore}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deleteDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-deleteDataStore}{}}}
\subsection{Method \code{deleteDataStore()}}{
Deletes a datastore given workspace and datastore names.
   By defaut, the option \code{recurse} is set to FALSE, ie datastore layers are not removed.
   To remove all datastore layers, set this option to TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$deleteDataStore(ws, ds, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatureTypes"></a>}}
\if{latex}{\out{\hypertarget{method-getFeatureTypes}{}}}
\subsection{Method \code{getFeatureTypes()}}{
Get the list of available feature types for given workspace and datastore.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureTypes(ws, ds, list = "configured")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{list}}{list type value, among "configured", "available", "available_with_geom", "all"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSFeatureType}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatureTypeNames"></a>}}
\if{latex}{\out{\hypertarget{method-getFeatureTypeNames}{}}}
\subsection{Method \code{getFeatureTypeNames()}}{
Get the list of available feature type names for given workspace and datastore.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureTypeNames(ws, ds)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of class\code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-getFeatureType}{}}}
\subsection{Method \code{getFeatureType()}}{
Get an object of class \code{\link{GSFeatureType}} given a workspace, datastore and feature type names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureType(ws, ds, ft)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{ft}}{feature type name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSFeatureType}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-createFeatureType}{}}}
\subsection{Method \code{createFeatureType()}}{
Creates a new featureType given a workspace, datastore names and an object of class \code{\link{GSFeatureType}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$createFeatureType(ws, ds, featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{feature type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-updateFeatureType}{}}}
\subsection{Method \code{updateFeatureType()}}{
Updates a featureType given a workspace, datastore names and an object of class \code{\link{GSFeatureType}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$updateFeatureType(ws, ds, featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{feature type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deleteFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-deleteFeatureType}{}}}
\subsection{Method \code{deleteFeatureType()}}{
Deletes a featureType given a workspace, datastore names, and an object of 
   class \code{\link{GSFeatureType}}. By defaut, the option \code{recurse} is 
   set to FALSE, ie datastore layers are not removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$deleteFeatureType(ws, ds, ft, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{ft}}{feature type name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-publishLayer"></a>}}
\if{latex}{\out{\hypertarget{method-publishLayer}{}}}
\subsection{Method \code{publishLayer()}}{
Publish a feature type/layer pair given a workspace and datastore. The name 'layer' here 
encompasses both \link{GSFeatureType} and \link{GSLayer} resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$publishLayer(ws, ds, featureType, layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{object of class \link{GSFeatureType}}

\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if published, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unpublishLayer"></a>}}
\if{latex}{\out{\hypertarget{method-unpublishLayer}{}}}
\subsection{Method \code{unpublishLayer()}}{
Unpublish a feature type/layer pair given a workspace and datastore. The name 'layer' here 
encompasses both \link{GSFeatureType} and \link{GSLayer} resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$unpublishLayer(ws, ds, lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if published, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadData"></a>}}
\if{latex}{\out{\hypertarget{method-uploadData}{}}}
\subsection{Method \code{uploadData()}}{
Uploads features data. The \code{extension} corresponds to the format/type of features to be uploaded among "shp", "spatialite", "h2", "gpkg". 
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadData(
  ws,
  ds,
  endpoint = "file",
  extension,
  configure = "first",
  update = "append",
  filename,
  charset,
  contentType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{extension}}{extension}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}

\item{\code{contentType}}{content type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadShapefile"></a>}}
\if{latex}{\out{\hypertarget{method-uploadShapefile}{}}}
\subsection{Method \code{uploadShapefile()}}{
Uploads zipped shapefile.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadShapefile(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadProperties"></a>}}
\if{latex}{\out{\hypertarget{method-uploadProperties}{}}}
\subsection{Method \code{uploadProperties()}}{
Uploads properties.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadProperties(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadH2"></a>}}
\if{latex}{\out{\hypertarget{method-uploadH2}{}}}
\subsection{Method \code{uploadH2()}}{
Uploads H2 database.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadH2(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadSpatialite"></a>}}
\if{latex}{\out{\hypertarget{method-uploadSpatialite}{}}}
\subsection{Method \code{uploadSpatialite()}}{
Uploads spatialite file.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadSpatialite(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadAppschema"></a>}}
\if{latex}{\out{\hypertarget{method-uploadAppschema}{}}}
\subsection{Method \code{uploadAppschema()}}{
Uploads App schema.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadAppschema(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadGeoPackage"></a>}}
\if{latex}{\out{\hypertarget{method-uploadGeoPackage}{}}}
\subsection{Method \code{uploadGeoPackage()}}{
Uploads GeoPackage.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadGeoPackage(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
