% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional.R
\name{Rbar}
\alias{Rbar}
\title{calculate \eqn{\bar{R}}}
\usage{
Rbar(trd, plg = 0, option = 0, degrees = FALSE)
}
\arguments{
\item{trd}{trend angle, in degrees, between 0 and 360 (if
\code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{plg}{(optional) plunge angle, in degrees, between 0 and 90
(if \code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{option}{scalar. If \code{option=0}, then \code{plg} is
ignored and the measurements are considered to be circular; if
\code{option=1}, then \code{trd} is the azimuth and \code{plg}
is the dip; if \code{option=2}, then \code{trd} is the strike
and \code{plg} is the dip; if \code{option=3} then \code{trd}
is the longitude and \code{plg} is the latitude.}

\item{degrees}{\code{TRUE} for degrees, \code{FALSE} for radians}
}
\value{
a value between 0 and 1
}
\description{
Given \eqn{n} circular or spherical measurements, the
    length of their normalised vector sum (\eqn{\bar{R}}) serves as
    a measure of directional concentration.
}
\examples{
data(striations,package='geostats')
Rbar(striations,degrees=TRUE)
}
