#' @name soilmoisture
#' @aliases soilmoisture
#' @title Soil moisture experiment
#'
#' @description Field experiment, realized in CTI (Tecnical Center of Irrigation), in an area of
#' 350 cm x 150 cm, with 355 observations in a regular grid.
#'
#' @docType data
#'
#' @usage data(soilmoisture)
#'
#' @format An object of class data.frame
#' @details
#' \itemize{
#' \item \bold{x} a vector containing the sample locations(in cm) in the horizontal.
#' \item \bold{y} a vector containing the sample locations(in cm) in the vertical.
#' \item \bold{z} a vector containing the value of soil moisture in percents.
#' }
#' @keywords datasets
#'
#' @references HARA. A. T., GONÇALVES, A. C. A. Temporal stability of the spatial pattern of water storage in the soil at different
#' spatial scales. (Doctoral thesis). Retrieved from url \url{http://www.pga.uem.br/dissertacao-tese/710}

NULL
