% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_geouy.R
\name{plot_geouy}
\alias{plot_geouy}
\title{plot_geouy}
\usage{
plot_geouy(x, col, viri_opt = "plasma", l = NULL, other_lab = NULL, ...)
}
\arguments{
\item{x}{An sf object like load_geouy() results}

\item{col}{Variable of "x" to plot (character)}

\item{viri_opt}{A character string indicating the colormap option to use. Four options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"), "viridis" (or "D", the default option) and "cividis" (or "E")}

\item{l}{If NULL none label added, if "\%" porcentage with 1 decimal labels, if "n" the value is the label, if "c" put other variable in other_lab. Default NULL}

\item{other_lab}{If l is "c" put here the variable name for the labels.}

\item{...}{All parameters allowed from ggplot2 themes.}
}
\value{
ggplot object of a choropleth map with x geometries and col values.
}
\description{
This function allows you to set ggplot2 theme in our suggested format.
}
\examples{
\donttest{
secc <- load_geouy("Secciones")
plot_geouy(x = secc, col = "AREA")
}

}
\keyword{ggplot2}
\keyword{maps}
\keyword{sf}
