% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_CRU_stack.R
\name{create_CRU_stack}
\alias{create_CRU_stack}
\title{Create a List of Raster Stack Objects From CRU CL v. 2.0 Climatology Variables on Local Disk}
\usage{
create_CRU_stack(pre = FALSE, pre_cv = FALSE, rd0 = FALSE, tmp = FALSE,
  dtr = FALSE, reh = FALSE, tmn = FALSE, tmx = FALSE, sunp = FALSE,
  frs = FALSE, wnd = FALSE, elv = FALSE, dsn = "")
}
\arguments{
\item{pre}{Logical. Create a raster stack of precipitation
(millimetres/month) from local files? Defaults to FALSE.}

\item{pre_cv}{Logical. Create a raster stack of cv of precipitation (percent)
from local files? Defaults to FALSE.}

\item{rd0}{Logical. Logical. Create a raster stack of wet days (number days
with >0.1 millimetres rain per month) from local files? Defaults to FALSE.}

\item{tmp}{Logical. Create a raster stack of temperature (degrees Celsius)
from local files? Defaults to FALSE.}

\item{dtr}{Logical. Create a raster stack of mean diurnal temperature range
(degrees Celsius) from local files? Defaults to FALSE.}

\item{reh}{Logical. Create a raster stack of relative humidity from local
files? Defaults to FALSE.}

\item{tmn}{Logical. Calculate minimum temperature values (degrees Celsius)
and return it in a raster stack? \emph{Requires tmp and dtr files to be
locally present}. Defaults to FALSE.}

\item{tmx}{Logical. Calculate maximum temperature values (degrees Celsius)
and return it in a raster stack? \emph{Requires tmp and dtr files to be
locally present}. Defaults to FALSE.}

\item{sunp}{Logical. Create a raster stack of sunshine, percent of maximum
possible (percent of day length) from local files? Defaults to FALSE.}

\item{frs}{Logical. Create a raster stack of ground-frost records (number of
days with ground-frost per month) from local files? Defaults to FALSE.}

\item{wnd}{Logical. Create a raster stack of 10m wind speed (metres/second)
from local files? Defaults to FALSE.}

\item{elv}{Logical. Create a raster layer of elevation (converted to metres)
from local files? Defaults to FALSE.}

\item{dsn}{Local file path where CRU CL v. 2.0 .dat.gz files are located.}
}
\value{
A \code{\link[base]{list}} of \code{\link{raster}}
\code{\link[raster]{stack}} objects of CRU CL v. 2.0 climatology elements
}
\description{
This function automates importing CRU CL v. 2.0 climatology data
into R from locally available data files and creates a list of raster stacks
of the data.  If requested, minimum and maximum temperature may also be
automatically calculated as described in the data readme.txt file.  This
function can be useful if you have network connection issues that mean
automated downloading of the files using R does not work properly.  In this
instance it is recommended to use an FTP client (e.g., FileZilla), web browser
or command line command (e.g., wget or curl) to download the files, save
locally and use this function to import the data into R.

Nomenclature and units from readme.txt:
\describe{
\item{pre}{precipitation (millimetres/month)}
 \describe{
   \item{cv}{cv of precipitation (percent)}
 }
\item{rd0}{wet-days (number days with >0.1mm rain per month)}
\item{tmp}{mean temperature (degrees Celsius)}
\item{dtr}{mean diurnal temperature range (degrees Celsius)}
\item{reh}{relative humidity (percent)}
\item{sunp}{sunshine (percent of maximum possible (percent of day length))}
\item{frs}{ground-frost (number of days with ground-frost per month)}
\item{wnd}{10 metre windspeed (metres/second)}
\item{elv}{elevation (automatically converted to metres)}
}
For more information see the description of the data provided by CRU,
\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/readme.txt}
}
\note{
This package automatically converts elevation values from kilometres to
metres.

This package crops all spatial outputs to an extent of ymin = -60, ymax = 85,
xmin = -180, xmax = 180. Note that the original wind data include land area
for parts of Antarctica, these data are excluded in the raster stacks
generated by this function.
}
\examples{
# Create a raster stack of precipitation and temperature from pre and tmp
# files in the Downloads directory.
\dontrun{
CRU_pre_tmp <- create_CRU_stack(pre = TRUE, tmp = TRUE, dsn = "~/Downloads")
}
}
\seealso{
\code{\link{get_CRU_stack}}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
