% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_dict.R
\name{get_data_dict}
\alias{get_data_dict}
\title{Get the WHO Data Dictionary for TB Data}
\usage{

  get_data_dict(url = "https://extranet.who.int/tme/generateCSV.asp?ds=dictionary",
  download_data = TRUE, save = TRUE, dict_save_name = "TB_data_dict",
  return = TRUE, verbose = TRUE, use_utils = FALSE,
  retry_download = TRUE)
}
\arguments{
\item{url}{Character string, indicating  the url of the data
dictionary. Default is current url.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{return}{Logical, should the data  dictionary be returned as a dataframe.
Defaults to \code{TRUE}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{use_utils}{Logical, defaults to \code{FALSE}. Used for testing alternative
data download function. When \code{TRUE} data is downloaded using \code{read.csv}.}

\item{retry_download}{Logical defaults to \code{TRUE}. When \code{TRUE}, if downloading
fails, the function will try repeatedly to download the data within 3 seconds, up
to 3 times.}
}
\value{
The WHO TB data dictionary as a tibble with 4 variables:
variable_name, dataset, code_list, definition.
}
\description{
Get the data dictionary for TB burden data from the WHO, see
\href{http://www.who.int/tb/country/data/download/en/}{here} for details. This function will first attempt
to load the data from the temporary directory (\code{\link[base]{tempdir}}). If that fails, and \code{download_data = TRUE}, it
will instead download the data.
}
\examples{

dict <- get_data_dict()

head(dict)

}
\seealso{
get_data search_data_dict
}
