% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tb_burden.R
\name{get_tb_burden}
\alias{get_tb_burden}
\title{Get the WHO TB Burden Data}
\usage{
get_tb_burden(
  url = NULL,
  download_data = TRUE,
  save = TRUE,
  burden_save_name = NULL,
  add_mdr_data = TRUE,
  additional_datasets = NULL,
  mdr_save_name = NULL,
  mdr_url = NULL,
  return = TRUE,
  verbose = FALSE,
  use_utils = FALSE,
  retry_download = TRUE
)
}
\arguments{
\item{url}{Character string, indicating  the url of the TB burden data.
Default is current url. This argument is depreciated and will be removed from future releases.
The TB burden URL is now supplied internally - see \code{\link[getTBinR]{available_datasets}} for details.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. This argument is depreciated
and will be removed from future releases. Dataset naming is now handled internally.}

\item{add_mdr_data}{Logical, defaults to \code{TRUE}. Should MDR TB burden data be downloaded and joined
to the TB burden data.}

\item{additional_datasets}{A character vector specifying the names of the additional datasets to import.
See \code{\link[getTBinR]{available_datasets}} for available datasets. Use "all" to download all available
datasets (experimental datasets such as incidence by age and sex are excluded from this list).}

\item{mdr_save_name}{Character string, name to save the MDR data under. This argument is depreciated
and will be removed from future releases. Dataset naming is now handled internally.}

\item{mdr_url}{Character string, indicating the url of the MDR TB data. This argument is depreciated
and will be removed from future releases.  The MDR-TB burden URL is now supplied internally -
see \code{\link[getTBinR]{available_datasets}} for details.}

\item{return}{Logical, should the data be returned as a dataframe.
Defaults to \code{TRUE}.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should additional status and progress messages
be displayed.}

\item{use_utils}{Logical, defaults to \code{FALSE}. Used for testing alternative
data download function. When \code{TRUE} data is downloaded using \code{read.csv}.}

\item{retry_download}{Logical defaults to \code{TRUE}. When \code{TRUE}, if downloading
fails, the function will try repeatedly to download the data within 3 seconds, up
to 3 times.}
}
\value{
The WHO TB burden data as a tibble.
}
\description{
Get the TB burden data, and multi-drug resistant TB (MDR-TB) data from the WHO, see
\href{http://www.who.int/tb/country/data/download/en/}{here} for details. This function will first attempt
to load the data from the temporary directory (\code{\link[base]{tempdir}}). If that fails, and \code{download_data = TRUE}, it
will instead download the data. The MDR TB data is only available for the latest year of data.
}
\examples{


## Default datasets
tb_burden <- get_tb_burden(additional_datasets = available_datasets$dataset[3])

head(tb_burden)

## Add in the latent TB dataset as an additional dataset (see getTBinR::avaiable_datasets)
tb_with_latents <- get_tb_burden(additional_datasets = available_datasets$dataset[3])

head(tb_with_latents)
}
\seealso{
get_data search_data_dict
}
