% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tb_burden.R
\name{plot_tb_burden}
\alias{plot_tb_burden}
\title{Plot TB Burden by Country}
\usage{
plot_tb_burden(
  df = NULL,
  dict = NULL,
  metric = "e_inc_100k",
  metric_label = NULL,
  smooth = FALSE,
  conf = c("_lo", "_hi"),
  countries = NULL,
  years = NULL,
  compare_to_region = FALSE,
  facet = NULL,
  legend = "none",
  annual_change = FALSE,
  trans = "identity",
  scales = "fixed",
  interactive = FALSE,
  download_data = TRUE,
  save = TRUE,
  viridis_palette = "viridis",
  viridis_direction = -1,
  viridis_end = 0.9,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{smooth}{Logical, defaults to \code{FALSE}. Should the data be smoothed (using \code{ggplot2::geom_smooth})
prior to plotting. If set to \code{TRUE} then the confidence intervals shown are derived from the smooth
and do not represent the underlying uncertainty in the data.}

\item{conf}{Character vector specifying the name variations to use to specify the upper
and lower confidence intervals. Defaults to c("_lo", "_hi"), if set to \code{NULL}
then no confidence intervals are shown. When \code{annual_change = TRUE} the confidence
intervals represent the annual percentage change in the metrics confidence intervals.}

\item{countries}{A character string specifying the countries to target.}

\item{years}{Numeric vector of years. Defaults to \code{NULL} which includes all years in the data.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{facet}{Character string, the name of the variable to facet by.}

\item{legend}{Character string, defaults to \code{"none"}. Position of the legend see \code{?ggplot2::theme} for defaults but known
options are: \code{"none"}, \code{"top"}, \code{"right"} and \code{"bottom"}.}

\item{annual_change}{Logical, defaults to \code{FALSE}. If \code{TRUE} then the
percentage annual change is computed for the specified metric.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{scales}{Character string, see ?ggplot2::facet_wrap for details. Defaults to "fixed",
alternatives are "free_y", "free_x", or "free".}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE} then an interactive plot is
returned.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{viridis_palette}{Character string indicating the \code{viridis} colour palette to use. Defaults
to "viridis". Options include "cividis", "magma", "inferno", "plasma", and "viridis". For additional details
see \code{\link[viridis]{viridis_pal}} for additional details.}

\item{viridis_direction}{Numeric, indicating the direction for the colour palette (1 or -1), defaults to -1.
See \code{\link[viridis]{scale_color_viridis}} for additional details.}

\item{viridis_end}{Numeric between 0 and 1, defaults to 0.9. The end point of the viridis scale to use.
#' See \code{\link[viridis]{scale_color_viridis}} for additional details.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional arguments to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A plot of TB Incidence Rates by Country
}
\description{
Plot measures of TB burden by country by specifying a metric from the TB burden data.
Specify a country or vector of countries in order to plot them (by default plots all countries).
Various other options are available for tuning the plot further.
}
\examples{

## Get the WHO TB burden data and the data dictionary
tb_burden <- get_tb_burden()
dict <- get_data_dict()

## Get a random sample of 9 countries
sample_countries <- sample(unique(tb_burden$country), 9)

## Plot incidence rates in these countries
plot_tb_burden(df = tb_burden, dict = dict, facet = "country", countries = sample_countries)
\dontrun{
## Plot smoothed incidence rates in these countries
plot_tb_burden(
  df = tb_burden, dict = dict, facet = "country", smooth = TRUE,
  countries = sample_countries
)
## Use data caching to plot incidence rates with free y scales
plot_tb_burden(facet = "country", countries = sample_countries, scales = "free_y")

## Plot annual percentage change in incidence rates in selected countries
plot_tb_burden(
  df = tb_burden, dict = dict, facet = "country", scales = "free_y",
  countries = sample_countries, annual_change = TRUE, conf = NULL
)

## Find variables relating to mortality in the WHO dataset
search_data_dict(def = "mortality")
## Plot mortality rates (exc HIV) - without progress messages
plot_tb_burden(
  metric = "e_mort_exc_tbhiv_100k", facet = "country",
  countries = sample_countries, scales = "free_y"
)
}
}
\seealso{
get_tb_burden search_data_dict
}
