% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred_fun_cov}
\alias{pred_fun_cov}
\title{Fit Covariate Models}
\usage{
pred_fun_cov(covparams, covnames, covtypes, covfits_custom, restrictions,
  time_name, obs_data)
}
\arguments{
\item{covparams}{List of vectors, where each vector contains information for
one parameter used in the modeling of the time-varying covariates (e.g.,
model statement, family, link function, etc.). Each vector
must be the same length as \code{covnames} and in the same order.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{covfits_custom}{Vector containing custom fit functions for time-varying covariates that
do not fall within the pre-defined covariate types. It should be in
the same order \code{covnames}. If a custom fit function is not
required for a particular covariate (e.g., if the first
covariate is of type \code{"binary"} but the second is of type \code{"custom"}), then that
index should be set to \code{NA}.}

\item{restrictions}{List of vectors. Each vector contains as its first entry a covariate for which
\emph{a priori} knowledge of its distribution is available; its second entry a condition
under which no knowledge of its distribution is available and that must be \code{TRUE}
for the distribution of that covariate given that condition to be estimated via a parametric
model or other fitting procedure; its third entry a function for estimating the distribution
of that covariate given the condition in the second entry is false such that \emph{a priori} knowledge
of the covariate distribution is available; and its fourth entry a value used by the function in the
third entry. The default is \code{NA}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{obs_data}{Data on which the models are fit.}
}
\value{
A list of fitted models, one for each covariate in \code{covnames}.
}
\description{
This internal function fits a model for each covariate using the observed data.
}
\keyword{internal}
