% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{fit_bounded_continuous}
\alias{fit_bounded_continuous}
\title{Fit Bounded Normal Model on Covariate}
\usage{
fit_bounded_continuous(covparams, covlink = NA, covname, obs_data, j,
  model_fits)
}
\arguments{
\item{covparams}{List of vectors, where each vector contains information for
one parameter used in the modeling of the time-varying covariates (e.g.,
model statement, family, link function, etc.).}

\item{covlink}{Vector of link functions.}

\item{covname}{Name of the covariate at index \eqn{j}.}

\item{obs_data}{Data on which the model is fit.}

\item{j}{Integer specifying the index of the covariate.}

\item{model_fits}{Logical scalar indicating whether to return the fitted models. The default is \code{FALSE}.}
}
\value{
Fitted model for the covariate at index \eqn{j}.
}
\description{
This internal function models a covariate using a "bounded normal" distribution
by first standardizing the covariate values to the range [0, 1], noninclusive,
then fitting a generalized linear model (GLM) under the Gaussian family function.
}
\keyword{internal}
